/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.runner;

import java.io.File;
import java.util.List;
import org.apache.maven.model.FileSet;

public class CodeNarcConfig {
    private final String projectName;
    private final List<FileSet> fileSets;
    private final File outputFile;
    private final boolean generateXmlReport;
    private final List<String> ruleSets;

    public static CodeNarcConfigBuilder builder() {
        return new CodeNarcConfigBuilder();
    }

    public String getProjectName() {
        return this.projectName;
    }

    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public boolean isGenerateXmlReport() {
        return this.generateXmlReport;
    }

    public List<String> getRuleSets() {
        return this.ruleSets;
    }

    public CodeNarcConfig(String projectName, List<FileSet> fileSets, File outputFile, boolean generateXmlReport, List<String> ruleSets) {
        this.projectName = projectName;
        this.fileSets = fileSets;
        this.outputFile = outputFile;
        this.generateXmlReport = generateXmlReport;
        this.ruleSets = ruleSets;
    }

    public static class CodeNarcConfigBuilder {
        private String projectName;
        private List<FileSet> fileSets;
        private File outputFile;
        private boolean generateXmlReport;
        private List<String> ruleSets;

        CodeNarcConfigBuilder() {
        }

        public CodeNarcConfigBuilder projectName(String projectName) {
            this.projectName = projectName;
            return this;
        }

        public CodeNarcConfigBuilder fileSets(List<FileSet> fileSets) {
            this.fileSets = fileSets;
            return this;
        }

        public CodeNarcConfigBuilder outputFile(File outputFile) {
            this.outputFile = outputFile;
            return this;
        }

        public CodeNarcConfigBuilder generateXmlReport(boolean generateXmlReport) {
            this.generateXmlReport = generateXmlReport;
            return this;
        }

        public CodeNarcConfigBuilder ruleSets(List<String> ruleSets) {
            this.ruleSets = ruleSets;
            return this;
        }

        public CodeNarcConfig build() {
            return new CodeNarcConfig(this.projectName, this.fileSets, this.outputFile, this.generateXmlReport, this.ruleSets);
        }

        public String toString() {
            return "CodeNarcConfig.CodeNarcConfigBuilder(projectName=" + this.projectName + ", fileSets=" + this.fileSets + ", outputFile=" + this.outputFile + ", generateXmlReport=" + this.generateXmlReport + ", ruleSets=" + this.ruleSets + ")";
        }
    }
}

