/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.runner;

import io.github.crizzis.codenarc.runner.CodeNarcConfig;
import io.github.crizzis.codenarc.runner.FileSetSourceAnalyzer;
import java.util.List;
import javax.inject.Named;
import javax.inject.Singleton;
import org.codenarc.CodeNarcRunner;
import org.codenarc.analyzer.SourceAnalyzer;
import org.codenarc.report.XmlReportWriter;

@Named
@Singleton
public class CodeNarcRunnerFactory {
    public CodeNarcRunner newCodeNarcRunner(CodeNarcConfig config) {
        CodeNarcRunner runner = new CodeNarcRunner();
        runner.setRuleSetFiles(this.joinedRuleSets(config));
        if (config.isGenerateXmlReport()) {
            this.configureXmlOutput(config, runner);
        }
        runner.setSourceAnalyzer((SourceAnalyzer)new FileSetSourceAnalyzer(config.getFileSets()));
        return runner;
    }

    private void configureXmlOutput(CodeNarcConfig config, CodeNarcRunner runner) {
        XmlReportWriter xmlReportWriter = new XmlReportWriter();
        xmlReportWriter.setTitle(config.getProjectName());
        xmlReportWriter.setOutputFile(config.getOutputFile().getAbsolutePath());
        runner.setReportWriters(List.of(xmlReportWriter));
    }

    private String joinedRuleSets(CodeNarcConfig config) {
        return String.join((CharSequence)",", config.getRuleSets());
    }
}

