/*
 * Decompiled with CFR 0.152.
 */
package io.github.crizzis.codenarc.runner;

import java.util.List;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.maven.model.FileSet;
import org.codenarc.analyzer.AbstractSourceAnalyzer;
import org.codenarc.analyzer.FilesystemSourceAnalyzer;
import org.codenarc.results.DirectoryResults;
import org.codenarc.results.Results;
import org.codenarc.ruleset.RuleSet;

class FileSetSourceAnalyzer
extends AbstractSourceAnalyzer {
    @NonNull
    private final List<FileSet> fileSets;

    public Results analyze(RuleSet ruleSet) {
        return (Results)this.fileSets.stream().map(fileSet -> this.analyze((FileSet)fileSet, ruleSet)).collect(Collector.of(DirectoryResults::new, DirectoryResults::addChild, (left, right) -> {
            right.getChildren().forEach(arg_0 -> ((DirectoryResults)left).addChild(arg_0));
            return left;
        }, new Collector.Characteristics[0]));
    }

    private Results analyze(FileSet fileSet, RuleSet ruleSet) {
        FilesystemSourceAnalyzer analyzer = new FilesystemSourceAnalyzer();
        analyzer.setBaseDirectory(fileSet.getDirectory());
        analyzer.setIncludes(String.join((CharSequence)",", fileSet.getIncludes()));
        analyzer.setExcludes(String.join((CharSequence)",", fileSet.getExcludes()));
        return (Results)analyzer.analyze(ruleSet).getChildren().get(0);
    }

    public List<String> getSourceDirectories() {
        return this.fileSets.stream().map(FileSet::getDirectory).collect(Collectors.toList());
    }

    public FileSetSourceAnalyzer(@NonNull List<FileSet> fileSets) {
        if (fileSets == null) {
            throw new NullPointerException("fileSets is marked non-null but is null");
        }
        this.fileSets = fileSets;
    }
}

