/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import java.util.ArrayList;
import net.csdn.davinci.Config;
import net.csdn.davinci.ui.activity.PhotoActivity;
import net.csdn.davinci.ui.activity.PreviewActivity;
import net.csdn.davinci.utils.PermissionsUtils;

public class DaVinci {
    public static final String KEY_SELECTED_PHOTOS = "SELECTED_PHOTOS";

    private DaVinci() {
    }

    public static DaVinciSelectBuilder select() {
        Config.reset();
        return new DaVinciSelectBuilder();
    }

    public static DaVinciPreviewBuilder preview() {
        return DaVinci.preview(true);
    }

    public static DaVinciPreviewBuilder preview(boolean reset) {
        if (reset) {
            Config.reset();
        }
        return new DaVinciPreviewBuilder();
    }

    private static ArrayList<String> createNewArray(ArrayList<String> oldList) {
        ArrayList<String> newList = new ArrayList<String>();
        if (oldList != null && oldList.size() > 0) {
            newList.addAll(oldList);
        }
        return newList;
    }

    public static interface QrScanCallback {
        public void onResult(String var1);
    }

    public static class DaVinciPreviewBuilder {
        private DaVinciPreviewBuilder() {
        }

        public DaVinciPreviewBuilder previewSelectable(boolean previewSelectable) {
            Config.previewSelectable = previewSelectable;
            return this;
        }

        public DaVinciPreviewBuilder selectedPhotos(ArrayList<String> selectedPhotos) {
            Config.selectedPhotos = DaVinci.createNewArray(selectedPhotos);
            return this;
        }

        public DaVinciPreviewBuilder previewPhotos(ArrayList<String> previewPhotos) {
            Config.previewPhotos = DaVinci.createNewArray(previewPhotos);
            return this;
        }

        public DaVinciPreviewBuilder needQrScan(boolean needQrScan) {
            Config.needQrScan = needQrScan;
            return this;
        }

        public DaVinciPreviewBuilder qrScanCallback(QrScanCallback callback) {
            Config.qrScanCallback = callback;
            return this;
        }

        public DaVinciPreviewBuilder saveFolderName(String folderName) {
            Config.saveFolderName = folderName;
            return this;
        }

        public void start(Activity activity) {
            if (activity == null) {
                return;
            }
            if (Config.previewPhotos == null || Config.previewPhotos.size() <= 0) {
                throw new IllegalArgumentException("Please set previewPhotos before preview");
            }
            this.start(activity, Config.previewPhotos.get(0));
        }

        public void start(Activity activity, String currentUri) {
            if (activity == null) {
                return;
            }
            Config.currentPath = TextUtils.isEmpty((CharSequence)currentUri) ? "" : currentUri;
            Intent intent = new Intent((Context)activity, PreviewActivity.class);
            activity.startActivityForResult(intent, 2048);
        }
    }

    public static class DaVinciSelectBuilder {
        private DaVinciSelectBuilder() {
        }

        public DaVinciSelectBuilder maxSelectable(int maxSelectable) {
            Config.maxSelectable = maxSelectable;
            return this;
        }

        public DaVinciSelectBuilder column(int column) {
            Config.column = column;
            return this;
        }

        public DaVinciSelectBuilder showGif(boolean showGif) {
            Config.showGif = showGif;
            return this;
        }

        public DaVinciSelectBuilder showCamera(boolean showCamera) {
            Config.showCamera = showCamera;
            return this;
        }

        public DaVinciSelectBuilder selectedPhotos(ArrayList<String> selectedPhotos) {
            Config.selectedPhotos = DaVinci.createNewArray(selectedPhotos);
            return this;
        }

        public void start(Activity activity, int requestCode) {
            if (activity == null) {
                return;
            }
            if (!PermissionsUtils.checkReadStoragePermission(activity)) {
                return;
            }
            Intent intent = new Intent((Context)activity, PhotoActivity.class);
            activity.startActivityForResult(intent, requestCode);
        }
    }
}

