/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.core.album;

import android.app.LoaderManager;
import android.content.Context;
import android.content.Loader;
import android.database.Cursor;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.csdn.davinci.R;
import net.csdn.davinci.core.album.AlbumLoader;
import net.csdn.davinci.core.album.AlbumResultCallback;
import net.csdn.davinci.core.entity.Album;
import net.csdn.davinci.core.entity.Photo;

public class AlbumLoaderCallback
implements LoaderManager.LoaderCallbacks<Cursor> {
    private static final String DIR_ALL_ID = "ALL";
    private final Context mContext;
    private AlbumResultCallback mCallback;

    public AlbumLoaderCallback(@NonNull Context context, AlbumResultCallback callback) {
        this.mContext = context;
        this.mCallback = callback;
    }

    @NonNull
    public Loader<Cursor> onCreateLoader(int id2, @Nullable Bundle args) {
        Log.e((String)"AlbumLoad", (String)("onCreateLoader====" + id2));
        return new AlbumLoader(this.mContext);
    }

    public void onLoadFinished(@NonNull Loader<Cursor> loader, Cursor data) {
        if (data == null) {
            return;
        }
        LinkedHashMap<String, Album> albums = new LinkedHashMap<String, Album>();
        Album albumAll = new Album();
        albumAll.id = DIR_ALL_ID;
        albumAll.name = this.mContext.getString(R.string.davinci_all_image);
        albums.put(DIR_ALL_ID, albumAll);
        while (data.moveToNext()) {
            Album album;
            int imageId = data.getInt(data.getColumnIndexOrThrow("_id"));
            String imagePath = data.getString(data.getColumnIndexOrThrow("_data"));
            String albumId = data.getString(data.getColumnIndexOrThrow("bucket_id"));
            String albumName = data.getString(data.getColumnIndexOrThrow("bucket_display_name"));
            if (!albums.containsKey(albumId)) {
                album = new Album();
                album.id = albumId;
                album.name = albumName;
                album.coverPath = imagePath;
                albums.put(albumId, album);
            } else {
                album = (Album)albums.get(albumId);
                if (album == null) {
                    album = new Album();
                    albums.put(albumId, album);
                }
            }
            Photo photo = new Photo();
            photo.id = String.valueOf(imageId);
            photo.imgPath = imagePath;
            album.photoList.add(photo);
            albumAll.photoList.add(photo);
        }
        ArrayList<Album> results = new ArrayList<Album>();
        for (Map.Entry entry : albums.entrySet()) {
            results.add((Album)entry.getValue());
        }
        albumAll.coverPath = results.size() <= 1 ? "" : ((Album)results.get((int)1)).coverPath;
        this.mCallback.onResult(results);
    }

    public void onLoaderReset(@NonNull Loader<Cursor> loader) {
    }
}

