/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.core.engine;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import com.bumptech.glide.Glide;
import com.bumptech.glide.Priority;
import com.bumptech.glide.load.model.GlideUrl;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.RequestOptions;
import com.bumptech.glide.request.target.Target;
import com.davemorrissey.labs.subscaleview.ImageSource;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import net.csdn.davinci.core.engine.ImageEngine;
import net.csdn.davinci.core.engine.ImageEventListener;
import net.csdn.davinci.core.engine.PhotoViewTarget;

public class GlideEngine
implements ImageEngine {
    @Override
    public void loadThumbnail(Context context, int resize, int placeResource, ImageView imageView, String path) {
        Glide.with((Context)context).load(path).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(resize, resize)).placeholder(placeResource)).centerCrop()).into(imageView);
    }

    @Override
    public void loadThumbnail(Context context, int resize, Drawable placeDrawable, ImageView imageView, String path) {
        Glide.with((Context)context).load(path).apply(((RequestOptions)((RequestOptions)new RequestOptions().override(resize, resize)).placeholder(placeDrawable)).centerCrop()).into(imageView);
    }

    @Override
    public void loadLocalImage(Context context, int resizeX, int resizeY, ImageView imageView, String path) {
        Glide.with((Context)context).load(path).apply(((RequestOptions)new RequestOptions().override(resizeX, resizeY)).priority(Priority.HIGH)).into(imageView);
    }

    @Override
    public void loadLocalLongImage(SubsamplingScaleImageView imageView, String path) {
        if (imageView == null) {
            return;
        }
        imageView.setOnImageEventListener((SubsamplingScaleImageView.OnImageEventListener)new ImageEventListener(imageView));
        imageView.setImage(ImageSource.uri((String)path));
    }

    @Override
    public void loadNetImage(Context context, ImageView imageView, String path, @Nullable RequestListener<Drawable> listener) {
        Glide.with((Context)context).load(path).addListener(listener).into(imageView);
    }

    @Override
    public void loadNetLongImage(Context context, String path, PhotoViewTarget target) {
        if (target == null) {
            return;
        }
        Glide.with((Context)context).download((Object)new GlideUrl(path)).into((Target)target);
    }
}

