/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.core.photo;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import androidx.core.content.FileProvider;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class PhotoCaptureManager {
    private static final String CAPTURED_PHOTO_PATH_KEY = "mCurrentPhotoPath";
    public static final int REQUEST_TAKE_PHOTO = 1;
    private String mCurrentPhotoPath;
    private Application mContext;

    private PhotoCaptureManager() {
    }

    public static PhotoCaptureManager getInstance(Application context) {
        if (InstanceHolder.instance.mContext == null && context != null) {
            InstanceHolder.instance.mContext = context;
        }
        return InstanceHolder.instance;
    }

    private File createImageFile() throws IOException {
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ENGLISH).format(new Date());
        String imageFileName = "JPEG_" + timeStamp + ".jpg";
        File storageDir = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES);
        if (!storageDir.exists() && !storageDir.mkdir()) {
            Log.e((String)"TAG", (String)"Throwing Errors....");
            throw new IOException();
        }
        File image = new File(storageDir, imageFileName);
        this.mCurrentPhotoPath = image.getAbsolutePath();
        return image;
    }

    public Intent dispatchTakePictureIntent() throws IOException {
        Intent takePictureIntent = new Intent("android.media.action.IMAGE_CAPTURE");
        if (takePictureIntent.resolveActivity(this.mContext.getPackageManager()) != null) {
            Uri photoFile;
            File file = this.createImageFile();
            if (Build.VERSION.SDK_INT >= 24) {
                String authority = this.mContext.getApplicationInfo().packageName + ".provider";
                photoFile = FileProvider.getUriForFile((Context)this.mContext.getApplicationContext(), (String)authority, (File)file);
            } else {
                photoFile = Uri.fromFile((File)file);
            }
            if (photoFile != null) {
                takePictureIntent.putExtra("output", (Parcelable)photoFile);
            }
        }
        return takePictureIntent;
    }

    public void galleryAddPic() {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        if (TextUtils.isEmpty((CharSequence)this.mCurrentPhotoPath)) {
            return;
        }
        File f = new File(this.mCurrentPhotoPath);
        Uri contentUri = Uri.fromFile((File)f);
        mediaScanIntent.setData(contentUri);
        this.mContext.sendBroadcast(mediaScanIntent);
    }

    public String getCurrentPhotoPath() {
        return this.mCurrentPhotoPath;
    }

    public void onSaveInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && this.mCurrentPhotoPath != null) {
            savedInstanceState.putString(CAPTURED_PHOTO_PATH_KEY, this.mCurrentPhotoPath);
        }
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        if (savedInstanceState != null && savedInstanceState.containsKey(CAPTURED_PHOTO_PATH_KEY)) {
            this.mCurrentPhotoPath = savedInstanceState.getString(CAPTURED_PHOTO_PATH_KEY);
        }
    }

    private static class InstanceHolder {
        private static final PhotoCaptureManager instance = new PhotoCaptureManager();

        private InstanceHolder() {
        }
    }
}

