/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.core.photo;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.FutureTarget;
import com.uuzuche.lib_zxing.activity.CodeUtils;
import java.io.File;
import java.lang.ref.WeakReference;
import net.csdn.davinci.Config;
import net.csdn.davinci.R;
import net.csdn.davinci.core.entity.SavePath;
import net.csdn.davinci.core.photo.PhotoHandleManager;
import net.csdn.davinci.ui.dialog.PermissionsDialog;
import net.csdn.davinci.utils.FileUtils;
import net.csdn.davinci.utils.PermissionsUtils;
import net.csdn.davinci.utils.SystemUtils;
import net.csdn.davinci.utils.UrlUtils;

public class PhotoHandleManagerImpl
implements PhotoHandleManager {
    private static final int MSG_GET_PATH = 11000;
    private PhotoHandler mHandler = new PhotoHandler();
    private Activity mActivity;
    private String mUrl;

    public PhotoHandleManagerImpl(Activity activity) {
        this.mActivity = activity;
    }

    @Override
    public void showLongClickDialog(final String url) {
        if (this.mActivity == null || TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (Config.absolutePathMap.containsKey(url)) {
            this.analysisBitmap(url, Config.absolutePathMap.get(url));
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    FutureTarget future = Glide.with((Activity)PhotoHandleManagerImpl.this.mActivity).load(url).downloadOnly(100, 100);
                    String path = "";
                    try {
                        File cacheFile = (File)future.get();
                        path = cacheFile.getAbsolutePath();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    SavePath data = new SavePath();
                    data.path = path;
                    data.url = url;
                    Message msg = Message.obtain();
                    msg.what = 11000;
                    msg.obj = data;
                    PhotoHandleManagerImpl.this.mHandler.sendMessage(msg);
                }
            }).start();
        }
    }

    private void analysisBitmap(final String url, String path) {
        if (!TextUtils.isEmpty((CharSequence)path) && Config.needQrScan) {
            CodeUtils.analyzeBitmap((String)path, (CodeUtils.AnalyzeCallback)new CodeUtils.AnalyzeCallback(){

                public void onAnalyzeSuccess(Bitmap mBitmap, String result) {
                    String host;
                    if (PhotoHandleManagerImpl.this.mActivity.isFinishing() || TextUtils.isEmpty((CharSequence)result)) {
                        return;
                    }
                    if (!UrlUtils.checkUrl(result)) {
                        PhotoHandleManagerImpl.this.showSelectDialog(url, null);
                        return;
                    }
                    if (!result.startsWith("http")) {
                        result = "https://" + result;
                    }
                    if (TextUtils.isEmpty((CharSequence)(host = UrlUtils.getHost(result)))) {
                        PhotoHandleManagerImpl.this.showSelectDialog(url, null);
                        return;
                    }
                    PhotoHandleManagerImpl.this.showSelectDialog(url, result);
                }

                public void onAnalyzeFailed() {
                    PhotoHandleManagerImpl.this.showSelectDialog(url, null);
                }
            });
        } else {
            this.showSelectDialog(url, null);
        }
    }

    private void showSelectDialog(final String url, final String result) {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this.mActivity);
        CharSequence[] showMsgArr = TextUtils.isEmpty((CharSequence)result) ? new String[]{"\u4fdd\u5b58\u56fe\u7247"} : new String[]{"\u4fdd\u5b58\u56fe\u7247", "\u8bc6\u522b\u56fe\u4e2d\u4e8c\u7ef4\u7801"};
        builder.setItems(showMsgArr, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface mdialog, int which) {
                if (which == 0) {
                    PhotoHandleManagerImpl.this.download(url);
                } else if (Config.qrScanCallback != null) {
                    Config.qrScanCallback.onResult(result);
                }
                if (SystemUtils.isActivityRunning(PhotoHandleManagerImpl.this.mActivity)) {
                    mdialog.dismiss();
                }
            }
        });
        if (SystemUtils.isActivityRunning(this.mActivity)) {
            builder.show();
        }
    }

    @Override
    public void download(String url) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.mUrl = url;
        }
        if (!PermissionsUtils.checkWriteStoragePermission(this.mActivity, false)) {
            PermissionsDialog dialog = new PermissionsDialog(10001, (Context)this.mActivity, new PermissionsDialog.OnButtonClickListener(){

                @Override
                public void onConfirmClick() {
                    if (Build.VERSION.SDK_INT >= 23) {
                        if (!PhotoHandleManagerImpl.this.mActivity.shouldShowRequestPermissionRationale("android.permission.WRITE_EXTERNAL_STORAGE")) {
                            ActivityCompat.requestPermissions((Activity)PhotoHandleManagerImpl.this.mActivity, (String[])PermissionsUtils.PERMISSIONS_EXTERNAL_WRITE, (int)3);
                        } else {
                            PermissionsUtils.openPermissionPage((Context)PhotoHandleManagerImpl.this.mActivity);
                        }
                    } else {
                        ActivityCompat.requestPermissions((Activity)PhotoHandleManagerImpl.this.mActivity, (String[])PermissionsUtils.PERMISSIONS_EXTERNAL_WRITE, (int)3);
                    }
                }
            });
            dialog.show(this.mActivity);
        } else {
            this.startDownload(url);
        }
    }

    private void startDownload(String url) {
        String downloadUrl = "";
        if (!TextUtils.isEmpty((CharSequence)url)) {
            downloadUrl = url;
        } else if (!TextUtils.isEmpty((CharSequence)this.mUrl)) {
            downloadUrl = this.mUrl;
        }
        if (TextUtils.isEmpty((CharSequence)downloadUrl)) {
            return;
        }
        new DownloadAsyncTask(this.mActivity, downloadUrl).execute(new Void[0]);
    }

    private static class DownloadAsyncTask
    extends AsyncTask<Void, Integer, File> {
        private final String mUrl;
        private WeakReference<Activity> mActivity;

        public DownloadAsyncTask(Activity activity, String url) {
            this.mUrl = url;
            this.mActivity = new WeakReference<Activity>(activity);
        }

        protected File doInBackground(Void ... params) {
            File file = null;
            try {
                Activity activity = (Activity)this.mActivity.get();
                if (activity == null) {
                    return null;
                }
                FutureTarget future = Glide.with((Activity)activity).load(this.mUrl).downloadOnly(Integer.MIN_VALUE, Integer.MIN_VALUE);
                file = (File)future.get();
                File pictureFolder = Environment.getExternalStoragePublicDirectory((String)Environment.DIRECTORY_PICTURES).getAbsoluteFile();
                File appDir = new File(pictureFolder, Config.saveFolderName);
                if (!appDir.exists()) {
                    appDir.mkdirs();
                }
                String fileName = Config.saveFolderName + "_" + System.currentTimeMillis() + (this.mUrl.endsWith(".gif") || this.mUrl.endsWith("=gif") ? ".gif" : ".jpg");
                File destFile = new File(appDir, fileName);
                FileUtils.copy(file, destFile);
                activity.sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.fromFile((File)new File(destFile.getPath()))));
            }
            catch (Exception e) {
                Log.e((String)"SAVE_PICTURE", (String)e.getMessage());
            }
            return file;
        }

        protected void onPostExecute(File file) {
            Activity activity = (Activity)this.mActivity.get();
            if (activity == null) {
                return;
            }
            if (file == null) {
                Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.davinci_save_fail), (int)0).show();
            } else {
                Toast.makeText((Context)activity, (CharSequence)activity.getResources().getString(R.string.davinci_save_success), (int)0).show();
            }
        }
    }

    @SuppressLint(value={"HandlerLeak"})
    private class PhotoHandler
    extends Handler {
        private PhotoHandler() {
        }

        public void handleMessage(@NonNull Message msg) {
            super.handleMessage(msg);
            if (msg.what == 11000) {
                SavePath data = (SavePath)msg.obj;
                if (!TextUtils.isEmpty((CharSequence)data.path)) {
                    Config.absolutePathMap.put(data.url, data.path);
                    PhotoHandleManagerImpl.this.analysisBitmap(data.url, data.path);
                } else {
                    PhotoHandleManagerImpl.this.analysisBitmap(data.url, null);
                }
            }
        }
    }
}

