/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.activity;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import java.io.IOException;
import java.util.ArrayList;
import net.csdn.davinci.BR;
import net.csdn.davinci.Config;
import net.csdn.davinci.R;
import net.csdn.davinci.core.entity.Album;
import net.csdn.davinci.core.entity.Photo;
import net.csdn.davinci.core.photo.PhotoCaptureManager;
import net.csdn.davinci.databinding.ActivityPhotoBinding;
import net.csdn.davinci.ui.adapter.PhotoAdapter;
import net.csdn.davinci.ui.viewmodel.PhotoViewModel;
import net.csdn.davinci.utils.PermissionsUtils;
import net.csdn.mvvm_java.bus.LiveDataBus;
import net.csdn.mvvm_java.ui.activity.BaseBindingViewModelActivity;
import net.csdn.statusbar.StatusBar;

public class PhotoActivity
extends BaseBindingViewModelActivity<ActivityPhotoBinding, PhotoViewModel> {
    private PhotoAdapter mAdapter;

    public int getLayoutId() {
        return R.layout.activity_photo;
    }

    public int getVariableId() {
        return BR.viewmodel;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        StatusBar.Builder().color(this.getResources().getColor(R.color.davinci_white)).fontMode(1001).change((Activity)this);
        this.setBinding();
        this.setListener();
        this.registerBus();
        ((PhotoViewModel)this.mViewModel).loadAlbum((Activity)this);
        this.changeConfirmStatus();
    }

    protected void onResume() {
        super.onResume();
        if (this.mAdapter != null) {
            this.mAdapter.notifyDataSetChanged();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        ((PhotoViewModel)this.mViewModel).onDestroy();
    }

    public void onBackPressed() {
        if (((ActivityPhotoBinding)this.mBinding).album.getVisibility() == 0) {
            ((ActivityPhotoBinding)this.mBinding).album.closeAlbum();
            ((ActivityPhotoBinding)this.mBinding).navigation.setArrowDown();
        } else {
            super.onBackPressed();
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode != -1) {
            return;
        }
        switch (requestCode) {
            case 1: {
                PhotoCaptureManager.getInstance(this.getApplication()).galleryAddPic();
                String path = PhotoCaptureManager.getInstance(this.getApplication()).getCurrentPhotoPath();
                Config.selectedPhotos.add(path);
                this.changeConfirmStatus();
                this.mAdapter.getDatas().add(0, new Photo(path));
                this.mAdapter.notifyDataSetChanged();
                break;
            }
            case 2048: {
                this.finishAndSetResult();
            }
        }
    }

    private void setBinding() {
        this.mAdapter = new PhotoAdapter((Context)this, new PhotoAdapter.OnPhotoSelectChangeListener(){

            @Override
            public void onChange() {
                PhotoActivity.this.changeConfirmStatus();
            }
        }, new PhotoAdapter.OnCameraClickListener(){

            @Override
            public void onClick() {
                if (!PermissionsUtils.checkCameraPermission((Activity)PhotoActivity.this)) {
                    return;
                }
                PhotoActivity.this.openCamera();
            }
        });
        ((ActivityPhotoBinding)this.mBinding).setAdapter(this.mAdapter);
        ((PhotoViewModel)this.mViewModel).mAlbumList.observe((LifecycleOwner)this, (Observer)new Observer<ArrayList<Album>>(){

            public void onChanged(ArrayList<Album> albums) {
                ((ActivityPhotoBinding)((PhotoActivity)PhotoActivity.this).mBinding).album.setData(albums);
                PhotoActivity.this.selectAlbum(albums.get(0));
            }
        });
    }

    private void setListener() {
        ((ActivityPhotoBinding)this.mBinding).navigation.setListener(v -> this.onBackPressed(), v -> {
            if (((ActivityPhotoBinding)this.mBinding).album.getVisibility() == 8) {
                ((ActivityPhotoBinding)this.mBinding).album.openAlbum();
                ((ActivityPhotoBinding)this.mBinding).navigation.setArrowUp();
            } else {
                this.closeAlbum();
            }
        }, v -> this.finishAndSetResult());
    }

    private void registerBus() {
        LiveDataBus.getInstance().with("album_select", Album.class).observe((LifecycleOwner)this, (Observer)new Observer<Album>(){

            public void onChanged(Album album) {
                PhotoActivity.this.selectAlbum(album);
                PhotoActivity.this.closeAlbum();
            }
        });
        LiveDataBus.getInstance().with("album_blank_click").observe((LifecycleOwner)this, (Observer)new Observer<Object>(){

            public void onChanged(Object o) {
                PhotoActivity.this.closeAlbum();
            }
        });
    }

    private void selectAlbum(Album album) {
        if (album == null) {
            return;
        }
        ((ActivityPhotoBinding)this.mBinding).navigation.setTitle(album.name);
        this.mAdapter.setDatas(album.photoList);
        ArrayList<String> list = new ArrayList<String>();
        for (Photo photo : album.photoList) {
            list.add(photo.imgPath);
        }
        Config.previewPhotos = list;
    }

    private void closeAlbum() {
        ((ActivityPhotoBinding)this.mBinding).album.closeAlbum();
        ((ActivityPhotoBinding)this.mBinding).navigation.setArrowDown();
    }

    private void openCamera() {
        try {
            Intent intent = PhotoCaptureManager.getInstance(this.getApplication()).dispatchTakePictureIntent();
            this.startActivityForResult(intent, 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ActivityNotFoundException e) {
            Log.e((String)"PhotoPickerFragment", (String)"No Activity Found to handle Intent", (Throwable)e);
        }
    }

    private void changeConfirmStatus() {
        if (Config.selectedPhotos.size() <= 0) {
            ((ActivityPhotoBinding)this.mBinding).navigation.setDoUnEnable();
        } else {
            ((ActivityPhotoBinding)this.mBinding).navigation.setDoEnable();
        }
    }

    private void finishAndSetResult() {
        Intent intent = new Intent();
        intent.putStringArrayListExtra("SELECTED_PHOTOS", Config.selectedPhotos);
        this.setResult(-1, intent);
        this.finish();
    }
}

