/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.activity;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.viewpager.widget.PagerAdapter;
import androidx.viewpager.widget.ViewPager;
import net.csdn.davinci.BR;
import net.csdn.davinci.Config;
import net.csdn.davinci.R;
import net.csdn.davinci.core.photo.PhotoHandleManager;
import net.csdn.davinci.core.photo.PhotoHandleManagerImpl;
import net.csdn.davinci.databinding.ActivityPreviewBinding;
import net.csdn.davinci.ui.adapter.PreviewPagerAdapter;
import net.csdn.davinci.ui.viewmodel.PreviewViewModel;
import net.csdn.mvvm_java.bus.LiveDataBus;
import net.csdn.mvvm_java.ui.activity.BaseBindingViewModelActivity;
import net.csdn.statusbar.StatusBar;

public class PreviewActivity
extends BaseBindingViewModelActivity<ActivityPreviewBinding, PreviewViewModel> {
    public static final int RESULT_PREVIEW = 2048;
    private PhotoHandleManager mHandleManager;

    public int getVariableId() {
        return BR.viewmodel;
    }

    public int getLayoutId() {
        return R.layout.activity_preview;
    }

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.overridePendingTransition(R.anim.davinci_fade_in, R.anim.davinci_fade_out);
        StatusBar.Builder().transparent(true).fontMode(1000).change((Activity)this);
        if (Config.previewPhotos == null) {
            this.finish();
            return;
        }
        this.mHandleManager = new PhotoHandleManagerImpl((Activity)this);
        this.setPage();
        this.setListener();
        this.setAdapter();
    }

    public void finish() {
        super.finish();
        this.overridePendingTransition(R.anim.davinci_fade_in, R.anim.davinci_fade_out);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 3) {
            boolean isAllGranted = true;
            for (int grant : grantResults) {
                if (grant == 0) continue;
                isAllGranted = false;
                break;
            }
            if (isAllGranted) {
                if (this.mHandleManager != null) {
                    this.mHandleManager.download(null);
                }
            } else {
                Toast.makeText((Context)this, (CharSequence)this.getResources().getString(R.string.davinci_no_permission_write), (int)1).show();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        try {
            return super.dispatchTouchEvent(ev);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void setListener() {
        ((ActivityPreviewBinding)this.mBinding).navigation.setListener(v -> this.finish(), v -> {
            Intent intent = new Intent();
            intent.putStringArrayListExtra("SELECTED_PHOTOS", Config.selectedPhotos);
            this.setResult(-1, intent);
            this.finish();
        });
        LiveDataBus.getInstance().with("preview_selected_click", String.class).observe((LifecycleOwner)this, (Observer)new Observer<String>(){

            public void onChanged(String path) {
                ((ActivityPreviewBinding)((PreviewActivity)PreviewActivity.this).mBinding).viewPager.setCurrentItem(Config.previewPhotos.indexOf(path), false);
            }
        });
        LiveDataBus.getInstance().with("preview_click").observe((LifecycleOwner)this, (Observer)new Observer<Object>(){

            public void onChanged(Object o) {
                if (!Config.previewSelectable) {
                    PreviewActivity.this.finish();
                    return;
                }
                if (((ActivityPreviewBinding)((PreviewActivity)PreviewActivity.this).mBinding).navigation.getVisibility() == 0) {
                    ((ActivityPreviewBinding)((PreviewActivity)PreviewActivity.this).mBinding).navigation.dismiss();
                    ((ActivityPreviewBinding)((PreviewActivity)PreviewActivity.this).mBinding).bottomBar.dismiss();
                } else {
                    ((ActivityPreviewBinding)((PreviewActivity)PreviewActivity.this).mBinding).navigation.show();
                    ((ActivityPreviewBinding)((PreviewActivity)PreviewActivity.this).mBinding).bottomBar.show();
                }
            }
        });
        LiveDataBus.getInstance().with("preview_long_click", String.class).observe((LifecycleOwner)this, (Observer)new Observer<String>(){

            public void onChanged(String url) {
                if (!url.startsWith("http")) {
                    return;
                }
                PreviewActivity.this.mHandleManager.showLongClickDialog(url);
            }
        });
    }

    private void setAdapter() {
        PreviewPagerAdapter adapter = new PreviewPagerAdapter(this.getSupportFragmentManager(), Config.previewPhotos);
        ((ActivityPreviewBinding)this.mBinding).viewPager.setAdapter((PagerAdapter)adapter);
        ((ActivityPreviewBinding)this.mBinding).viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                Config.currentPath = Config.previewPhotos.get(position);
                ((ActivityPreviewBinding)((PreviewActivity)PreviewActivity.this).mBinding).bottomBar.notifyDataSetChanged();
                PreviewActivity.this.setPage();
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        ((ActivityPreviewBinding)this.mBinding).viewPager.setCurrentItem(Config.previewPhotos.indexOf(Config.currentPath), false);
    }

    private void setPage() {
        if (Config.previewPhotos == null) {
            return;
        }
        ((ActivityPreviewBinding)this.mBinding).tvPage.setText((CharSequence)this.getResources().getString(R.string.davinci_pager_page, new Object[]{Config.previewPhotos.indexOf(Config.currentPath) + 1, Config.previewPhotos.size()}));
    }
}

