/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.adapter;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import net.csdn.davinci.Config;
import net.csdn.davinci.DaVinci;
import net.csdn.davinci.R;
import net.csdn.davinci.core.entity.Photo;
import net.csdn.davinci.utils.DensityUtils;
import net.csdn.davinci.utils.SystemUtils;

public class PhotoAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_CAMERA = 1000;
    private static final int TYPE_PHOTO = 1001;
    private int mImageWidth;
    private Context mContext;
    private List<Photo> mDatas;
    private OnPhotoSelectChangeListener mListener;
    private OnCameraClickListener mOnCameraClickListener;

    public PhotoAdapter(Context context, OnPhotoSelectChangeListener listener, OnCameraClickListener onCameraClickListener) {
        this.mContext = context;
        this.mListener = listener;
        this.mOnCameraClickListener = onCameraClickListener;
        this.mImageWidth = (SystemUtils.getScreenWidth(context) - DensityUtils.dp2px(context, Config.column)) / 4;
    }

    public void setDatas(List<Photo> datas) {
        this.mDatas = datas;
        this.notifyDataSetChanged();
    }

    public List<Photo> getDatas() {
        return this.mDatas;
    }

    public int getItemCount() {
        int count;
        int n = count = this.mDatas == null || this.mDatas.size() == 0 ? 0 : this.mDatas.size();
        if (Config.showCamera) {
            return count + 1;
        }
        return count;
    }

    public int getItemViewType(int position) {
        return Config.showCamera && position == 0 ? 1000 : 1001;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == 1000) {
            return new CameraHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_photo_camera, parent, false));
        }
        return new PhotoHolder(LayoutInflater.from((Context)parent.getContext()).inflate(R.layout.item_photo, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder viewHolder, int position) {
        if (viewHolder instanceof CameraHolder) {
            boolean canClick;
            CameraHolder cameraHolder = (CameraHolder)viewHolder;
            boolean bl = canClick = Config.selectedPhotos.size() < Config.maxSelectable;
            if (!canClick) {
                cameraHolder.viewShadow.setVisibility(0);
            } else {
                cameraHolder.viewShadow.setVisibility(8);
            }
            viewHolder.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (!canClick) {
                        Toast.makeText((Context)PhotoAdapter.this.mContext, (CharSequence)PhotoAdapter.this.mContext.getString(R.string.davinci_over_max_count_tips, new Object[]{Config.maxSelectable}), (int)0).show();
                        return;
                    }
                    if (PhotoAdapter.this.mOnCameraClickListener != null) {
                        PhotoAdapter.this.mOnCameraClickListener.onClick();
                    }
                }
            });
            return;
        }
        final PhotoHolder holder = (PhotoHolder)viewHolder;
        final Photo photo = Config.showCamera ? this.mDatas.get(position - 1) : this.mDatas.get(position);
        Config.imageEngine.loadThumbnail(this.mContext, this.mImageWidth, R.color.davinci_place_holder, holder.ivPhoto, photo.imgPath);
        boolean isSelected = Config.selectedPhotos.contains(photo.imgPath);
        holder.rlSelected.setSelected(isSelected);
        holder.tvSelected.setText((CharSequence)(isSelected ? Config.selectedPhotos.indexOf(photo.imgPath) + 1 + "" : ""));
        holder.viewShadow.setVisibility(Config.selectedPhotos.size() >= Config.maxSelectable && !isSelected ? 0 : 8);
        holder.ivPhoto.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                DaVinci.preview(false).previewSelectable(true).start((Activity)PhotoAdapter.this.mContext, photo.imgPath);
            }
        });
        holder.rlSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!view.isSelected() && Config.selectedPhotos.size() >= Config.maxSelectable) {
                    return;
                }
                view.setSelected(!view.isSelected());
                if (view.isSelected()) {
                    Config.selectedPhotos.add(photo.imgPath);
                    if (Config.selectedPhotos.size() < Config.maxSelectable) {
                        holder.tvSelected.setText((CharSequence)(view.isSelected() ? Config.selectedPhotos.indexOf(photo.imgPath) + 1 + "" : ""));
                    } else {
                        PhotoAdapter.this.notifyDataSetChanged();
                    }
                } else {
                    Config.selectedPhotos.remove(photo.imgPath);
                    PhotoAdapter.this.notifyDataSetChanged();
                }
                if (PhotoAdapter.this.mListener != null) {
                    PhotoAdapter.this.mListener.onChange();
                }
            }
        });
    }

    static class CameraHolder
    extends RecyclerView.ViewHolder {
        private View viewShadow;

        CameraHolder(View itemView) {
            super(itemView);
            this.viewShadow = itemView.findViewById(R.id.view_shadow);
        }
    }

    static class PhotoHolder
    extends RecyclerView.ViewHolder {
        private ImageView ivPhoto;
        private RelativeLayout rlSelected;
        private TextView tvSelected;
        private View viewShadow;

        PhotoHolder(View itemView) {
            super(itemView);
            this.ivPhoto = (ImageView)itemView.findViewById(R.id.iv_photo);
            this.rlSelected = (RelativeLayout)itemView.findViewById(R.id.rl_selected);
            this.tvSelected = (TextView)itemView.findViewById(R.id.tv_selected);
            this.viewShadow = itemView.findViewById(R.id.view_shadow);
        }
    }

    public static interface OnCameraClickListener {
        public void onClick();
    }

    public static interface OnPhotoSelectChangeListener {
        public void onChange();
    }
}

