/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import net.csdn.davinci.R;
import net.csdn.davinci.utils.SystemUtils;

public class PermissionsDialog
extends Dialog {
    public static final int TYPE_STORAGE_READ = 10000;
    public static final int TYPE_STORAGE_WRITE = 10001;
    public static final int TYPE_CAMERA = 10002;
    private OnButtonClickListener mListener;
    private String mTitle;
    private String mDescribe;
    int mType;

    public PermissionsDialog(int type, @NonNull Context context, OnButtonClickListener listener) {
        this(context, R.style.DaVinciDialog);
        this.mType = type;
        this.mListener = listener;
        this.init();
    }

    private PermissionsDialog(@NonNull Context context, int themeResId) {
        super(context, themeResId);
    }

    private void init() {
        this.setContentView(R.layout.dialog_permissions);
        this.setCancelable(false);
        this.setCanceledOnTouchOutside(false);
        LinearLayout llCancel = (LinearLayout)this.findViewById(R.id.ll_cancel);
        LinearLayout llOk = (LinearLayout)this.findViewById(R.id.ll_ok);
        TextView tvDesc = (TextView)this.findViewById(R.id.tv_desc);
        TextView tvTitle = (TextView)this.findViewById(R.id.tv_title);
        this.findText();
        tvTitle.setText((CharSequence)this.mTitle);
        tvDesc.setText((CharSequence)this.mDescribe);
        llOk.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionsDialog.this.dismiss();
                if (PermissionsDialog.this.mListener != null) {
                    PermissionsDialog.this.mListener.onConfirmClick();
                }
            }
        });
        llCancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PermissionsDialog.this.dismiss();
            }
        });
    }

    private void findText() {
        String appName = SystemUtils.getAppName(this.getContext());
        appName = !TextUtils.isEmpty((CharSequence)appName) ? "\"" + appName + "\"" : "";
        switch (this.mType) {
            case 10002: {
                this.mTitle = this.getContext().getString(R.string.davinci_permission_title_camera);
                this.mDescribe = this.getContext().getString(R.string.davinci_permission_desc_camera, new Object[]{appName});
                break;
            }
            case 10000: {
                this.mTitle = this.getContext().getString(R.string.davinci_permission_title_read);
                this.mDescribe = this.getContext().getString(R.string.davinci_permission_desc_read, new Object[]{appName});
                break;
            }
            case 10001: {
                this.mTitle = this.getContext().getString(R.string.davinci_permission_title_write);
                this.mDescribe = this.getContext().getString(R.string.davinci_permission_desc_write, new Object[]{appName});
                break;
            }
        }
    }

    public void show(Activity activity) {
        if (SystemUtils.isActivityRunning(activity)) {
            super.show();
        }
    }

    public static interface OnButtonClickListener {
        public void onConfirmClick();
    }
}

