/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.fragment;

import android.app.Activity;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.Nullable;
import androidx.databinding.library.baseAdapters.BR;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.GlideException;
import com.bumptech.glide.request.RequestListener;
import com.bumptech.glide.request.target.Target;
import java.io.File;
import net.csdn.davinci.Config;
import net.csdn.davinci.R;
import net.csdn.davinci.core.engine.PhotoViewTarget;
import net.csdn.davinci.databinding.FragmentPreviewBinding;
import net.csdn.davinci.ui.viewmodel.PreviewFragmentViewModel;
import net.csdn.davinci.utils.PhotoUtils;
import net.csdn.mvvm_java.ui.fragment.BaseBindingViewModelFragment;

public class PreviewFragment
extends BaseBindingViewModelFragment<FragmentPreviewBinding, PreviewFragmentViewModel> {
    private static final String ARGS_ITEM = "args_item";

    public static PreviewFragment newInstance(String path) {
        PreviewFragment fragment = new PreviewFragment();
        Bundle bundle = new Bundle();
        bundle.putString(ARGS_ITEM, path);
        fragment.setArguments(bundle);
        return fragment;
    }

    public int getLayoutId() {
        return R.layout.fragment_preview;
    }

    public int getVariableId() {
        return BR.viewmodel;
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getArguments() == null) {
            return;
        }
        ((PreviewFragmentViewModel)this.mViewModel).setPath(this.getArguments().getString(ARGS_ITEM));
        if (((PreviewFragmentViewModel)this.mViewModel).getPath() == null) {
            return;
        }
        ((FragmentPreviewBinding)this.mBinding).iv.setVisibility(0);
        ((FragmentPreviewBinding)this.mBinding).ivLong.setVisibility(8);
        ((FragmentPreviewBinding)this.mBinding).ivLong.setMaxScale(20.0f);
        if (((PreviewFragmentViewModel)this.mViewModel).getPath().startsWith("http")) {
            ((FragmentPreviewBinding)this.mBinding).progressBar.setVisibility(0);
            Config.imageEngine.loadNetImage(this.getContext(), (ImageView)((FragmentPreviewBinding)this.mBinding).iv, ((PreviewFragmentViewModel)this.mViewModel).getPath(), new RequestListener<Drawable>(){

                public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                    ((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).progressBar.setVisibility(8);
                    return false;
                }

                public boolean onResourceReady(Drawable resource, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                    ((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).iv.setImageDrawable(resource);
                    int height = resource.getBounds().height();
                    int width = resource.getBounds().width();
                    boolean longerImage = ((PreviewFragmentViewModel)PreviewFragment.this.mViewModel).isLongerImage(width, height);
                    if (!longerImage) {
                        ((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).iv.setScaleType(ImageView.ScaleType.FIT_CENTER);
                        ((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).progressBar.setVisibility(8);
                        return false;
                    }
                    ((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).iv.setVisibility(8);
                    ((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).ivLong.setVisibility(0);
                    Config.imageEngine.loadNetLongImage(PreviewFragment.this.getContext(), ((PreviewFragmentViewModel)PreviewFragment.this.mViewModel).getPath(), new PhotoViewTarget(((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).ivLong, ((FragmentPreviewBinding)((PreviewFragment)PreviewFragment.this).mBinding).progressBar));
                    return true;
                }
            });
        } else {
            ((FragmentPreviewBinding)this.mBinding).progressBar.setVisibility(8);
            Point originSize = PhotoUtils.getOriginSize(((PreviewFragmentViewModel)this.mViewModel).getPath(), (Activity)this.getActivity());
            if (!((PreviewFragmentViewModel)this.mViewModel).isLongerImage(originSize.x, originSize.y)) {
                Point size = PhotoUtils.getBitmapSize(Uri.fromFile((File)new File(((PreviewFragmentViewModel)this.mViewModel).getPath())), (Activity)this.getActivity());
                ((FragmentPreviewBinding)this.mBinding).iv.setScaleType(ImageView.ScaleType.FIT_CENTER);
                Config.imageEngine.loadLocalImage(this.getContext(), size.x, size.y, (ImageView)((FragmentPreviewBinding)this.mBinding).iv, ((PreviewFragmentViewModel)this.mViewModel).getPath());
            } else {
                ((FragmentPreviewBinding)this.mBinding).iv.setVisibility(8);
                ((FragmentPreviewBinding)this.mBinding).ivLong.setVisibility(0);
                ((FragmentPreviewBinding)this.mBinding).iv.setScaleType(ImageView.ScaleType.CENTER_CROP);
                Config.imageEngine.loadLocalLongImage(((FragmentPreviewBinding)this.mBinding).ivLong, ((PreviewFragmentViewModel)this.mViewModel).getPath());
            }
        }
    }
}

