/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import net.csdn.davinci.BR;
import net.csdn.davinci.R;
import net.csdn.davinci.core.entity.Album;
import net.csdn.davinci.databinding.ItemAlbumBinding;
import net.csdn.davinci.databinding.ViewPhotoAlbumBinding;
import net.csdn.davinci.ui.viewmodel.AlbumItemViewModel;
import net.csdn.mvvm_java.bus.LiveDataBus;
import net.csdn.mvvm_java.ui.adapter.BindingViewModelAdapter;

public class PhotoAlbum
extends RelativeLayout {
    private ViewPhotoAlbumBinding mBinding;
    private BindingViewModelAdapter<Album, ItemAlbumBinding> mAdapter;

    public PhotoAlbum(Context context) {
        this(context, null);
    }

    public PhotoAlbum(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PhotoAlbum(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mBinding = ViewPhotoAlbumBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        this.mAdapter = new BindingViewModelAdapter(R.layout.item_album, BR.viewmodel, AlbumItemViewModel.class, null);
        this.mBinding.setAdapter(this.mAdapter);
        this.mBinding.setOnBlankClick(new View.OnClickListener(){

            public void onClick(View v) {
                LiveDataBus.getInstance().with("album_blank_click").setValue(null);
            }
        });
    }

    public void openAlbum() {
        if (this.getVisibility() == 0) {
            return;
        }
        this.setVisibility(0);
        TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, -1.0f, 1, 0.0f);
        translateAnimation.setDuration(150L);
        translateAnimation.setFillEnabled(true);
        translateAnimation.setFillAfter(true);
        this.mBinding.rvDirs.startAnimation((Animation)translateAnimation);
    }

    public void closeAlbum() {
        if (this.getVisibility() == 8) {
            return;
        }
        TranslateAnimation translateAnimation = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, -1.0f);
        translateAnimation.setDuration(150L);
        translateAnimation.setFillEnabled(true);
        translateAnimation.setFillAfter(true);
        translateAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PhotoAlbum.this.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mBinding.rvDirs.startAnimation((Animation)translateAnimation);
    }

    public void setData(ArrayList<Album> albums) {
        this.mAdapter.setDatas(albums);
    }
}

