/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.LinearLayout;
import android.widget.Toast;
import net.csdn.davinci.Config;
import net.csdn.davinci.R;
import net.csdn.davinci.databinding.ViewPreviewBottomBarBinding;
import net.csdn.davinci.ui.adapter.PreviewSelectedAdapter;

public class PreviewBottomBar
extends LinearLayout {
    private ViewPreviewBottomBarBinding mBinding;
    private PreviewSelectedAdapter mAdapter;

    public PreviewBottomBar(Context context) {
        this(context, null);
    }

    public PreviewBottomBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PreviewBottomBar(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mBinding = ViewPreviewBottomBarBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        this.mAdapter = new PreviewSelectedAdapter(Config.selectedPhotos);
        this.mBinding.setAdapter(this.mAdapter);
        this.notifyDataSetChanged();
        this.setListener();
    }

    private void setListener() {
        this.mBinding.rlSelected.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!((PreviewBottomBar)PreviewBottomBar.this).mBinding.tvSelected.isSelected() && Config.selectedPhotos.size() >= Config.maxSelectable) {
                    Toast.makeText((Context)PreviewBottomBar.this.getContext(), (CharSequence)PreviewBottomBar.this.getContext().getString(R.string.davinci_over_max_count_tips, new Object[]{Config.maxSelectable}), (int)0).show();
                    return;
                }
                view.setSelected(!view.isSelected());
                if (view.isSelected()) {
                    Config.selectedPhotos.add(Config.currentPath);
                    ((PreviewBottomBar)PreviewBottomBar.this).mBinding.tvSelected.setText((CharSequence)String.valueOf(Config.selectedPhotos.indexOf(Config.currentPath) + 1));
                } else {
                    Config.selectedPhotos.remove(Config.currentPath);
                    ((PreviewBottomBar)PreviewBottomBar.this).mBinding.tvSelected.setText((CharSequence)"");
                }
                if (PreviewBottomBar.this.mAdapter != null) {
                    PreviewBottomBar.this.mAdapter.setSelectedItem(((PreviewBottomBar)PreviewBottomBar.this).mBinding.rv, Config.selectedPhotos.indexOf(Config.currentPath));
                    PreviewBottomBar.this.mAdapter.setDatas(Config.selectedPhotos);
                }
            }
        });
    }

    public void show() {
        if (!Config.previewSelectable || this.getVisibility() == 0) {
            return;
        }
        this.setVisibility(0);
        TranslateAnimation anim2 = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 1.0f, 1, 0.0f);
        anim2.setDuration(200L);
        anim2.setFillEnabled(true);
        anim2.setFillAfter(true);
        this.startAnimation((Animation)anim2);
    }

    public void dismiss() {
        if (!Config.previewSelectable || this.getVisibility() == 8) {
            return;
        }
        TranslateAnimation anim2 = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, 1.0f);
        anim2.setDuration(200L);
        anim2.setFillEnabled(true);
        anim2.setFillAfter(true);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PreviewBottomBar.this.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation((Animation)anim2);
    }

    public void notifyDataSetChanged() {
        if (this.mAdapter != null && Config.selectedPhotos != null) {
            this.mAdapter.setSelectedItem(this.mBinding.rv, Config.selectedPhotos.contains(Config.currentPath) ? Config.selectedPhotos.indexOf(Config.currentPath) : -1);
            this.mAdapter.notifyDataSetChanged();
            this.mBinding.rlSelected.setSelected(Config.selectedPhotos.contains(Config.currentPath));
            this.mBinding.tvSelected.setText((CharSequence)String.valueOf(Config.selectedPhotos.contains(Config.currentPath) ? Integer.valueOf(Config.selectedPhotos.indexOf(Config.currentPath) + 1) : ""));
        }
    }
}

