/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.TranslateAnimation;
import android.widget.RelativeLayout;
import java.util.ArrayList;
import net.csdn.davinci.Config;
import net.csdn.davinci.databinding.ViewPreviewNavigationBinding;
import net.csdn.statusbar.StatusBar;

public class PreviewNavigation
extends RelativeLayout {
    private ViewPreviewNavigationBinding mBinding;
    private View.OnClickListener mOnConfirmClickListener;

    public PreviewNavigation(Context context) {
        this(context, null);
    }

    public PreviewNavigation(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PreviewNavigation(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    private void init(Context context) {
        this.mBinding = ViewPreviewNavigationBinding.inflate(LayoutInflater.from((Context)context), (ViewGroup)this, true);
        this.mBinding.setStatusBarHeight(StatusBar.getHeight((Context)context));
        this.mBinding.setOnConfirmClick(new View.OnClickListener(){

            public void onClick(View v) {
                if (Config.selectedPhotos == null || Config.selectedPhotos.size() <= 0) {
                    Config.selectedPhotos = new ArrayList();
                    Config.selectedPhotos.add(Config.currentPath);
                }
                if (Config.selectedPhotos.size() > 0 && PreviewNavigation.this.mOnConfirmClickListener != null) {
                    PreviewNavigation.this.mOnConfirmClickListener.onClick(v);
                }
            }
        });
    }

    public void setListener(View.OnClickListener onBackClick, View.OnClickListener onConfirmClick) {
        this.mBinding.setOnBackClick(onBackClick);
        this.mOnConfirmClickListener = onConfirmClick;
    }

    public void show() {
        if (this.getVisibility() == 0) {
            return;
        }
        this.setVisibility(0);
        TranslateAnimation anim2 = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, -1.0f, 1, 0.0f);
        anim2.setDuration(200L);
        anim2.setFillEnabled(true);
        anim2.setFillAfter(true);
        this.startAnimation((Animation)anim2);
    }

    public void dismiss() {
        if (this.getVisibility() == 8) {
            return;
        }
        TranslateAnimation anim2 = new TranslateAnimation(1, 0.0f, 1, 0.0f, 1, 0.0f, 1, -1.0f);
        anim2.setDuration(200L);
        anim2.setFillEnabled(true);
        anim2.setFillAfter(true);
        anim2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                PreviewNavigation.this.setVisibility(8);
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.startAnimation((Animation)anim2);
    }
}

