/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.utils;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import androidx.annotation.RequiresApi;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import net.csdn.davinci.ui.dialog.PermissionsDialog;

public class PermissionsUtils {
    public static final int REQUEST_CAMERA = 1;
    public static final int REQUEST_EXTERNAL_READ = 2;
    public static final int REQUEST_EXTERNAL_WRITE = 3;
    public static final String[] PERMISSIONS_CAMERA = new String[]{"android.permission.CAMERA", "android.permission.WRITE_EXTERNAL_STORAGE"};
    public static final String[] PERMISSIONS_EXTERNAL_WRITE = new String[]{"android.permission.WRITE_EXTERNAL_STORAGE"};
    @RequiresApi(api=16)
    public static final String[] PERMISSIONS_EXTERNAL_READ = new String[]{"android.permission.READ_EXTERNAL_STORAGE"};

    public static boolean checkReadStoragePermission(final Activity activity) {
        boolean readStoragePermissionGranted;
        int readStoragePermissionState = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.READ_EXTERNAL_STORAGE");
        boolean bl = readStoragePermissionGranted = readStoragePermissionState == 0;
        if (!readStoragePermissionGranted) {
            PermissionsDialog dialog = new PermissionsDialog(10000, (Context)activity, new PermissionsDialog.OnButtonClickListener(){

                @Override
                public void onConfirmClick() {
                    if (Build.VERSION.SDK_INT >= 23) {
                        if (!activity.shouldShowRequestPermissionRationale("android.permission.READ_EXTERNAL_STORAGE")) {
                            ActivityCompat.requestPermissions((Activity)activity, (String[])PERMISSIONS_EXTERNAL_READ, (int)2);
                        } else {
                            PermissionsUtils.openPermissionPage((Context)activity);
                        }
                    } else {
                        ActivityCompat.requestPermissions((Activity)activity, (String[])PERMISSIONS_EXTERNAL_READ, (int)2);
                    }
                }
            });
            dialog.show(activity);
        }
        return readStoragePermissionGranted;
    }

    public static boolean checkWriteStoragePermission(Activity activity, boolean isRequest) {
        boolean writeStoragePermissionGranted;
        int writeStoragePermissionState = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        boolean bl = writeStoragePermissionGranted = writeStoragePermissionState == 0;
        if (!writeStoragePermissionGranted && isRequest) {
            ActivityCompat.requestPermissions((Activity)activity, (String[])PERMISSIONS_EXTERNAL_WRITE, (int)3);
        }
        return writeStoragePermissionGranted;
    }

    public static boolean checkCameraPermission(final Activity activity) {
        boolean cameraPermissionGranted;
        int cameraPermissionState = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.CAMERA");
        int writePermissionState = ContextCompat.checkSelfPermission((Context)activity, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
        boolean bl = cameraPermissionGranted = cameraPermissionState == 0 && writePermissionState == 0;
        if (!cameraPermissionGranted) {
            PermissionsDialog dialog = new PermissionsDialog(10002, (Context)activity, new PermissionsDialog.OnButtonClickListener(){

                @Override
                public void onConfirmClick() {
                    if (Build.VERSION.SDK_INT >= 23) {
                        if (!activity.shouldShowRequestPermissionRationale("android.permission.CAMERA")) {
                            ActivityCompat.requestPermissions((Activity)activity, (String[])PERMISSIONS_CAMERA, (int)1);
                        } else {
                            PermissionsUtils.openPermissionPage((Context)activity);
                        }
                    } else {
                        ActivityCompat.requestPermissions((Activity)activity, (String[])PERMISSIONS_CAMERA, (int)1);
                    }
                }
            });
            dialog.show(activity);
        }
        return cameraPermissionGranted;
    }

    public static void openPermissionPage(Context context) {
        String brand = Build.BRAND;
        if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"redmi") || TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"xiaomi")) {
            PermissionsUtils.gotoMiuiPermission(context);
        } else if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"meizu")) {
            PermissionsUtils.gotoMeizuPermission(context);
        } else if (TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"huawei") || TextUtils.equals((CharSequence)brand.toLowerCase(), (CharSequence)"honor")) {
            PermissionsUtils.gotoHuaweiPermission(context);
        } else {
            context.startActivity(PermissionsUtils.getAppDetailSettingIntent(context));
        }
    }

    private static void gotoMiuiPermission(Context context) {
        try {
            Intent localIntent = new Intent("miui.intent.action.APP_PERM_EDITOR");
            localIntent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.PermissionsEditorActivity");
            localIntent.putExtra("extra_pkgname", context.getPackageName());
            context.startActivity(localIntent);
        }
        catch (Exception e) {
            try {
                Intent localIntent = new Intent("miui.intent.action.APP_PERM_EDITOR");
                localIntent.setClassName("com.miui.securitycenter", "com.miui.permcenter.permissions.AppPermissionsEditorActivity");
                localIntent.putExtra("extra_pkgname", context.getPackageName());
                context.startActivity(localIntent);
            }
            catch (Exception e1) {
                context.startActivity(PermissionsUtils.getAppDetailSettingIntent(context));
            }
        }
    }

    private static void gotoMeizuPermission(Context context) {
        try {
            Intent intent = new Intent("com.meizu.safe.security.SHOW_APPSEC");
            intent.addCategory("android.intent.category.DEFAULT");
            intent.putExtra("packageName", context.getPackageName());
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.startActivity(PermissionsUtils.getAppDetailSettingIntent(context));
        }
    }

    private static void gotoHuaweiPermission(Context context) {
        try {
            Intent intent = new Intent();
            intent.setFlags(0x10000000);
            ComponentName comp = new ComponentName("com.huawei.systemmanager", "com.huawei.permissionmanager.ui.MainActivity");
            intent.setComponent(comp);
            context.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
            context.startActivity(PermissionsUtils.getAppDetailSettingIntent(context));
        }
    }

    private static Intent getAppDetailSettingIntent(Context context) {
        Intent localIntent = new Intent();
        localIntent.addFlags(0x10000000);
        localIntent.setAction("android.settings.APPLICATION_DETAILS_SETTINGS");
        localIntent.setData(Uri.fromParts((String)"package", (String)context.getPackageName(), null));
        return localIntent;
    }
}

