/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.davinci.utils;

import android.app.Activity;
import android.content.ContentResolver;
import android.database.Cursor;
import android.graphics.BitmapFactory;
import android.graphics.Point;
import android.media.ExifInterface;
import android.net.Uri;
import android.util.DisplayMetrics;
import android.util.Log;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import net.csdn.davinci.utils.ExifInterfaceCompat;

public final class PhotoUtils {
    private static final String TAG = PhotoUtils.class.getSimpleName();
    private static final int MAX_WIDTH = 1600;
    private static final String SCHEME_CONTENT = "content";

    private PhotoUtils() {
    }

    public static int getPixelsCount(ContentResolver resolver, Uri uri) {
        Point size = PhotoUtils.getBitmapBound(resolver, uri);
        return size.x * size.y;
    }

    public static Point getOriginSize(String path, Activity activity) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)path, (BitmapFactory.Options)options);
        return new Point(options.outWidth, options.outHeight);
    }

    public static Point getBitmapSize(Uri uri, Activity activity) {
        ContentResolver resolver = activity.getContentResolver();
        Point imageSize = PhotoUtils.getBitmapBound(resolver, uri);
        int w = imageSize.x;
        int h = imageSize.y;
        if (PhotoUtils.shouldRotate(resolver, uri)) {
            w = imageSize.y;
            h = imageSize.x;
        }
        if (h == 0) {
            return new Point(1600, 1600);
        }
        DisplayMetrics metrics = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        float screenWidth = metrics.widthPixels;
        float screenHeight = metrics.heightPixels;
        float widthScale = screenWidth / (float)w;
        float heightScale = screenHeight / (float)h;
        if (widthScale > heightScale) {
            return new Point((int)((float)w * widthScale), (int)((float)h * heightScale));
        }
        return new Point((int)((float)w * widthScale), (int)((float)h * heightScale));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Point getBitmapBound(ContentResolver resolver, Uri uri) {
        InputStream is = null;
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            options.inJustDecodeBounds = true;
            is = resolver.openInputStream(uri);
            BitmapFactory.decodeStream((InputStream)is, null, (BitmapFactory.Options)options);
            int width = options.outWidth;
            int height = options.outHeight;
            Point point = new Point(width, height);
            return point;
        }
        catch (FileNotFoundException e) {
            Point point = new Point(0, 0);
            return point;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPath(ContentResolver resolver, Uri uri) {
        if (uri == null) {
            return null;
        }
        if (SCHEME_CONTENT.equals(uri.getScheme())) {
            try (Cursor cursor = null;){
                cursor = resolver.query(uri, new String[]{"_data"}, null, null, null);
                if (cursor == null || !cursor.moveToFirst()) {
                    String string2 = null;
                    return string2;
                }
                String string3 = cursor.getString(cursor.getColumnIndex("_data"));
                return string3;
            }
        }
        return uri.getPath();
    }

    private static boolean shouldRotate(ContentResolver resolver, Uri uri) {
        ExifInterface exif;
        try {
            exif = ExifInterfaceCompat.newInstance(PhotoUtils.getPath(resolver, uri));
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("could not read exif info of the image: " + uri));
            return false;
        }
        int orientation = exif.getAttributeInt("Orientation", -1);
        return orientation == 6 || orientation == 8;
    }
}

