/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mvvm_java.bus;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import net.csdn.mvvm_java.bus.LiveDataBus;
import net.csdn.mvvm_java.bus.Observable;

public class BusMutableLiveData<T>
extends MutableLiveData<T>
implements Observable<T> {
    private final String key;
    private final Map<Observer<? super T>, Observer<? super T>> observerMap = new HashMap<Observer<? super T>, Observer<? super T>>();
    private final Handler mainHandler = new Handler(Looper.getMainLooper());

    public BusMutableLiveData(String key) {
        this.key = key;
    }

    @Override
    public void postValue(T value) {
        this.mainHandler.post((Runnable)new PostValueRunnable(value));
    }

    @Override
    public void postValueDelay(T value, long delay) {
        this.mainHandler.postDelayed((Runnable)new PostValueRunnable(value), delay);
    }

    @Override
    public void observe(@NonNull LifecycleOwner owner, @NonNull Observer<? super T> observer) {
        super.observe(owner, observer);
        this.hook(observer);
    }

    @Override
    public void observeForever(@NonNull Observer<? super T> observer) {
        if (!this.observerMap.containsKey(observer)) {
            this.observerMap.put(observer, new ObserverWrapper<T>(observer));
        }
        super.observeForever(this.observerMap.get(observer));
    }

    @Override
    public void removeObserver(@NonNull Observer<? super T> observer) {
        Observer<? super T> realObserver = null;
        if (this.observerMap.containsKey(observer)) {
            realObserver = this.observerMap.remove(observer);
        }
        if (realObserver == null) {
            realObserver = observer;
        }
        super.removeObserver(realObserver);
        if (!this.hasObservers()) {
            LiveDataBus.getInstance().getBus().remove(this.key);
        }
    }

    private void hook(@NonNull Observer<? super T> observer) {
        try {
            Class<LiveData> classLiveData = LiveData.class;
            Field fieldObservers = classLiveData.getDeclaredField("mObservers");
            fieldObservers.setAccessible(true);
            Object objectObservers = fieldObservers.get(this);
            Class<?> classObservers = objectObservers.getClass();
            Method methodGet = classObservers.getDeclaredMethod("get", Object.class);
            methodGet.setAccessible(true);
            Object objectWrapperEntry = methodGet.invoke(objectObservers, observer);
            Object objectWrapper = null;
            if (objectWrapperEntry instanceof Map.Entry) {
                objectWrapper = ((Map.Entry)objectWrapperEntry).getValue();
            }
            if (objectWrapper == null) {
                throw new NullPointerException("Wrapper can not be bull!");
            }
            Class<?> classObserverWrapper = objectWrapper.getClass().getSuperclass();
            Field fieldLastVersion = classObserverWrapper.getDeclaredField("mLastVersion");
            fieldLastVersion.setAccessible(true);
            Field fieldVersion = classLiveData.getDeclaredField("mVersion");
            fieldVersion.setAccessible(true);
            Object objectVersion = fieldVersion.get(this);
            fieldLastVersion.set(objectWrapper, objectVersion);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class ObserverWrapper<T>
    implements Observer<T> {
        private Observer<T> observer;

        public ObserverWrapper(Observer<T> observer) {
            this.observer = observer;
        }

        public void onChanged(@Nullable T t) {
            if (this.observer != null) {
                if (this.isCallOnObserve()) {
                    return;
                }
                this.observer.onChanged(t);
            }
        }

        private boolean isCallOnObserve() {
            StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
            if (stackTrace.length > 0) {
                for (StackTraceElement element : stackTrace) {
                    if (!"android.arch.lifecycle.LiveData".equals(element.getClassName()) || !"observeForever".equals(element.getMethodName())) continue;
                    return true;
                }
            }
            return false;
        }
    }

    private class PostValueRunnable
    implements Runnable {
        private final T newValue;

        public PostValueRunnable(T newValue) {
            this.newValue = newValue;
        }

        @Override
        public void run() {
            BusMutableLiveData.this.setValue(this.newValue);
        }
    }
}

