/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mvvm_java.ui.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.databinding.DataBindingUtil;
import androidx.databinding.ViewDataBinding;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.List;
import net.csdn.mvvm_java.ui.adapter.AdapterMethod;

public abstract class BaseAdapter<T, DB extends ViewDataBinding>
extends RecyclerView.Adapter<BindingHolder<DB>>
implements AdapterMethod<T> {
    protected final int mLayoutId;
    protected final int mVariableId;
    protected List<T> mDatas;

    protected BaseAdapter(@LayoutRes int layoutId, int variableId, List<T> datas) {
        this.mLayoutId = layoutId;
        this.mVariableId = variableId;
        this.mDatas = datas;
        if (this.mDatas == null) {
            this.mDatas = new ArrayList<T>();
        }
    }

    @NonNull
    public BindingHolder<DB> onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        ViewDataBinding binding = DataBindingUtil.inflate((LayoutInflater)LayoutInflater.from((Context)parent.getContext()), (int)this.mLayoutId, (ViewGroup)parent, (boolean)false);
        return new BindingHolder<ViewDataBinding>(binding);
    }

    public void onBindViewHolder(@NonNull BindingHolder<DB> holder, int position) {
        if (position >= this.mDatas.size()) {
            return;
        }
        this.onBind(position, holder.mBinding, this.mDatas.get(position));
        holder.mBinding.executePendingBindings();
    }

    public int getItemCount() {
        return this.mDatas.size();
    }

    @Override
    public List<T> getDatas() {
        return this.mDatas;
    }

    @Override
    public void setDatas(List<T> datas) {
        this.mDatas = datas;
        this.createDatas();
        this.notifyDataSetChanged();
    }

    @Override
    public void addDatas(List<T> datas) {
        if (datas == null || datas.size() <= 0) {
            return;
        }
        this.createDatas();
        this.mDatas.addAll(datas);
        this.notifyItemRangeInserted(this.mDatas.size() - datas.size(), datas.size());
    }

    @Override
    public void addDatas(int position, List<T> datas) {
        if (datas == null || datas.size() <= 0) {
            return;
        }
        this.createDatas();
        this.mDatas.addAll(position, datas);
        this.notifyItemRangeInserted(position, datas.size());
    }

    @Override
    public void addData(T data) {
        if (data == null) {
            return;
        }
        this.createDatas();
        this.mDatas.add(data);
        this.notifyItemInserted(this.mDatas.size() - 1);
    }

    @Override
    public void addData(int position, T data) {
        if (data == null) {
            return;
        }
        this.createDatas();
        this.mDatas.add(position, data);
        this.notifyItemInserted(position);
    }

    @Override
    public void removeData(int position) {
        if (this.mDatas == null || this.mDatas.size() <= 0) {
            return;
        }
        this.mDatas.remove(position);
        this.notifyItemRemoved(position);
    }

    private void createDatas() {
        if (this.mDatas == null) {
            this.mDatas = new ArrayList<T>();
        }
    }

    public abstract void onBind(int var1, DB var2, T var3);

    public static class BindingHolder<DB extends ViewDataBinding>
    extends RecyclerView.ViewHolder {
        public final DB mBinding;

        public BindingHolder(@NonNull DB binding) {
            super(binding.getRoot());
            this.mBinding = binding;
        }
    }
}

