/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.mvvm_java.ui.adapter;

import androidx.annotation.LayoutRes;
import androidx.databinding.ViewDataBinding;
import java.util.List;
import net.csdn.mvvm_java.ui.adapter.BaseAdapter;
import net.csdn.mvvm_java.viewmodel.BaseAdapterViewModel;

public class BindingViewModelAdapter<T, DB extends ViewDataBinding>
extends BaseAdapter<T, DB> {
    private final Class<? extends BaseAdapterViewModel<T>> mVmClass;

    public BindingViewModelAdapter(@LayoutRes int layoutId, int variableId, Class<? extends BaseAdapterViewModel<T>> clazz) {
        this(layoutId, variableId, clazz, null);
    }

    public BindingViewModelAdapter(@LayoutRes int layoutId, int variableId, Class<? extends BaseAdapterViewModel<T>> clazz, List<T> datas) {
        super(layoutId, variableId, datas);
        this.mVmClass = clazz;
    }

    @Override
    public void onBind(int position, DB dataBinding, T data) {
        BaseAdapterViewModel<T> instance = this.getViewModelInstance(position, data);
        if (instance != null) {
            dataBinding.setVariable(this.mVariableId, instance);
        }
    }

    private BaseAdapterViewModel<T> getViewModelInstance(int position, T data) {
        BaseAdapterViewModel<T> instance = null;
        if (this.mVmClass != null) {
            try {
                instance = this.mVmClass.getDeclaredConstructor(Integer.TYPE, data.getClass()).newInstance(position, data);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }
}

