/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.statusbar;

import android.app.Activity;
import android.content.Context;
import net.csdn.statusbar.core.Helper;
import net.csdn.statusbar.core.HelperImpl;
import net.csdn.statusbar.core.bean.BarColor;
import net.csdn.statusbar.core.bean.BarTransparent;

public class StatusBar {
    private StatusBar() {
    }

    public static int getHeight(Context context) {
        int resourceId;
        int result = 0;
        if (context != null && (resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android")) > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        return result;
    }

    public static StatusBarBuilder Builder() {
        return new StatusBarBuilder();
    }

    public static class StatusBarBuilder {
        private BarColor mStatusBarColor;
        private BarTransparent mTransparent;
        private int mFontMode = 0;

        private StatusBarBuilder() {
        }

        public StatusBarBuilder color(int color) {
            this.mStatusBarColor = new BarColor(color);
            return this;
        }

        public StatusBarBuilder transparent(boolean isTransparent) {
            this.mTransparent = new BarTransparent(isTransparent);
            return this;
        }

        public StatusBarBuilder fontMode(int fontMode) {
            this.mFontMode = fontMode;
            return this;
        }

        public void change(Activity activity) {
            if (activity != null) {
                Helper helper = HelperImpl.getInstance();
                helper.changeStatusBar(activity, this.mStatusBarColor, this.mFontMode, this.mTransparent);
            }
        }
    }
}

