/*
 * Decompiled with CFR 0.152.
 */
package net.csdn.statusbar.core;

import android.app.Activity;
import android.os.Build;
import android.view.Window;
import androidx.annotation.NonNull;
import net.csdn.statusbar.core.Helper;
import net.csdn.statusbar.core.bean.BarColor;
import net.csdn.statusbar.core.bean.BarTransparent;

public class HelperImpl
implements Helper {
    private HelperImpl() {
    }

    public static Helper getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void changeStatusBar(@NonNull Activity activity, BarColor barColor, int fontMode, BarTransparent transparent) {
        Window window = activity.getWindow();
        int visibility = window.getDecorView().getSystemUiVisibility();
        if (transparent == null) {
            if (fontMode != 0) {
                visibility = visibility == 1024 || visibility == 1280 || visibility == 9216 ? 1024 : 0;
                visibility = this.addFontMode(visibility, fontMode);
            }
        } else if (fontMode != 0) {
            visibility = transparent.isTransparent ? 1024 : 0;
            visibility = this.addFontMode(visibility, fontMode);
        } else {
            visibility = visibility == 9216 || visibility == 8192 ? (transparent.isTransparent ? 1024 : 0) | 0x2000 : (transparent.isTransparent ? 1024 : 0) | 0x100;
        }
        window.getDecorView().setSystemUiVisibility(visibility);
        if (transparent != null && transparent.isTransparent || barColor != null) {
            if (Build.VERSION.SDK_INT >= 23) {
                window.clearFlags(0x4000000);
                window.addFlags(Integer.MIN_VALUE);
            }
            window.setStatusBarColor(transparent != null && transparent.isTransparent ? 0 : barColor.color);
        }
    }

    @Override
    public int addFontMode(int visibility, int fontMode) {
        if (fontMode != 0) {
            if (fontMode == 1000) {
                visibility |= 0x100;
            } else if (Build.VERSION.SDK_INT >= 23) {
                visibility |= 0x2000;
            }
        }
        return visibility;
    }

    private static class Holder {
        static Helper INSTANCE = new HelperImpl();

        private Holder() {
        }
    }
}

