/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.layoutmanager;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Pair;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.fullspan.FullSpanAdapterType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0016B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\f\u0010\u0015\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/chad/library/adapter/base/layoutmanager/BrvahGridLayoutManager;", "Landroidx/recyclerview/widget/GridLayoutManager;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "spanCount", "(Landroid/content/Context;I)V", "orientation", "reverseLayout", "", "(Landroid/content/Context;IIZ)V", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "onAdapterChanged", "", "oldAdapter", "newAdapter", "FullSpanSizeLookup", "com.github.CymChad.brvah"})
public final class BrvahGridLayoutManager
extends GridLayoutManager {
    @Nullable
    private RecyclerView.Adapter<?> adapter;

    public BrvahGridLayoutManager(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setSpanSizeLookup(new FullSpanSizeLookup());
    }

    public BrvahGridLayoutManager(@NotNull Context context, int spanCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, spanCount);
        this.setSpanSizeLookup(new FullSpanSizeLookup());
    }

    public BrvahGridLayoutManager(@NotNull Context context, int spanCount, int orientation, boolean reverseLayout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, spanCount, orientation, reverseLayout);
        this.setSpanSizeLookup(new FullSpanSizeLookup());
    }

    public void onAdapterChanged(@Nullable RecyclerView.Adapter<?> oldAdapter, @Nullable RecyclerView.Adapter<?> newAdapter) {
        this.adapter = newAdapter;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/chad/library/adapter/base/layoutmanager/BrvahGridLayoutManager$FullSpanSizeLookup;", "Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;", "(Lcom/chad/library/adapter/base/layoutmanager/BrvahGridLayoutManager;)V", "getSpanSize", "", "position", "com.github.CymChad.brvah"})
    private final class FullSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        public int getSpanSize(int position) {
            int type;
            RecyclerView.Adapter adapter = BrvahGridLayoutManager.this.adapter;
            if (adapter == null) {
                return 1;
            }
            RecyclerView.Adapter adapter2 = adapter;
            if (adapter2 instanceof ConcatAdapter) {
                int n;
                Pair pair = ((ConcatAdapter)adapter2).getWrappedAdapterAndPosition(position);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"adapter.getWrappedAdapterAndPosition(position)");
                Pair pair2 = pair;
                RecyclerView.Adapter wrappedAdapter = (RecyclerView.Adapter)pair2.first;
                if (wrappedAdapter instanceof FullSpanAdapterType) {
                    n = BrvahGridLayoutManager.this.getSpanCount();
                } else if (wrappedAdapter instanceof BaseQuickAdapter) {
                    Object object = pair2.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.second");
                    int type2 = wrappedAdapter.getItemViewType(((Number)object).intValue());
                    n = ((BaseQuickAdapter)wrappedAdapter).isFullSpanItem(type2) ? BrvahGridLayoutManager.this.getSpanCount() : 1;
                } else {
                    n = 1;
                }
                return n;
            }
            RecyclerView.Adapter adapter3 = adapter2;
            int n = adapter3 instanceof FullSpanAdapterType ? BrvahGridLayoutManager.this.getSpanCount() : (adapter3 instanceof BaseQuickAdapter ? (((BaseQuickAdapter)adapter2).isFullSpanItem(type = adapter2.getItemViewType(position)) ? BrvahGridLayoutManager.this.getSpanCount() : 1) : 1);
            return n;
        }
    }
}

