/*
 * Decompiled with CFR 0.152.
 */
package com.chad.library.adapter.base.layoutmanager;

import android.content.Context;
import android.util.AttributeSet;
import android.util.Pair;
import androidx.annotation.CallSuper;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.fullspan.FullSpanAdapterType;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u0001!B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u000bB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ$\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00112\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011H\u0017J\u0012\u0010\u0018\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J \u0010\u001b\u001a\u00020\u00152\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\f\u0010\u001c\u001a\b\u0018\u00010\u001dR\u00020\u001aH\u0016J\u0012\u0010\u001e\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0012\u001a\u00060\u0013R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/chad/library/adapter/base/layoutmanager/QuickGridLayoutManager;", "Landroidx/recyclerview/widget/GridLayoutManager;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "spanCount", "(Landroid/content/Context;I)V", "orientation", "reverseLayout", "", "(Landroid/content/Context;IIZ)V", "adapter", "Landroidx/recyclerview/widget/RecyclerView$Adapter;", "fullSpanSizeLookup", "Lcom/chad/library/adapter/base/layoutmanager/QuickGridLayoutManager$FullSpanSizeLookup;", "onAdapterChanged", "", "oldAdapter", "newAdapter", "onAttachedToWindow", "view", "Landroidx/recyclerview/widget/RecyclerView;", "onDetachedFromWindow", "recycler", "Landroidx/recyclerview/widget/RecyclerView$Recycler;", "setSpanSizeLookup", "spanSizeLookup", "Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;", "FullSpanSizeLookup", "com.github.CymChad.brvah"})
public class QuickGridLayoutManager
extends GridLayoutManager {
    @NotNull
    private final FullSpanSizeLookup fullSpanSizeLookup;
    @Nullable
    private RecyclerView.Adapter<?> adapter;

    public QuickGridLayoutManager(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.fullSpanSizeLookup = new FullSpanSizeLookup();
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(this.getSpanSizeLookup());
        super.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.fullSpanSizeLookup);
    }

    public QuickGridLayoutManager(@NotNull Context context, int spanCount) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, spanCount);
        this.fullSpanSizeLookup = new FullSpanSizeLookup();
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(this.getSpanSizeLookup());
        super.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.fullSpanSizeLookup);
    }

    public QuickGridLayoutManager(@NotNull Context context, int spanCount, int orientation, boolean reverseLayout) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, spanCount, orientation, reverseLayout);
        this.fullSpanSizeLookup = new FullSpanSizeLookup();
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(this.getSpanSizeLookup());
        super.setSpanSizeLookup((GridLayoutManager.SpanSizeLookup)this.fullSpanSizeLookup);
    }

    @CallSuper
    public void onAdapterChanged(@Nullable RecyclerView.Adapter<?> oldAdapter, @Nullable RecyclerView.Adapter<?> newAdapter) {
        this.adapter = newAdapter;
    }

    public void onAttachedToWindow(@Nullable RecyclerView view) {
        super.onAttachedToWindow(view);
        RecyclerView recyclerView = view;
        this.adapter = recyclerView != null ? recyclerView.getAdapter() : null;
    }

    public void onDetachedFromWindow(@Nullable RecyclerView view, @Nullable RecyclerView.Recycler recycler) {
        super.onDetachedFromWindow(view, recycler);
        this.adapter = null;
    }

    public void setSpanSizeLookup(@Nullable GridLayoutManager.SpanSizeLookup spanSizeLookup) {
        this.fullSpanSizeLookup.setOriginalSpanSizeLookup(spanSizeLookup);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/chad/library/adapter/base/layoutmanager/QuickGridLayoutManager$FullSpanSizeLookup;", "Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;", "(Lcom/chad/library/adapter/base/layoutmanager/QuickGridLayoutManager;)V", "originalSpanSizeLookup", "getOriginalSpanSizeLookup", "()Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;", "setOriginalSpanSizeLookup", "(Landroidx/recyclerview/widget/GridLayoutManager$SpanSizeLookup;)V", "getSpanSize", "", "position", "com.github.CymChad.brvah"})
    private final class FullSpanSizeLookup
    extends GridLayoutManager.SpanSizeLookup {
        @Nullable
        private GridLayoutManager.SpanSizeLookup originalSpanSizeLookup;

        @Nullable
        public final GridLayoutManager.SpanSizeLookup getOriginalSpanSizeLookup() {
            return this.originalSpanSizeLookup;
        }

        public final void setOriginalSpanSizeLookup(@Nullable GridLayoutManager.SpanSizeLookup spanSizeLookup) {
            this.originalSpanSizeLookup = spanSizeLookup;
        }

        public int getSpanSize(int position) {
            int n;
            RecyclerView.Adapter adapter = QuickGridLayoutManager.this.adapter;
            if (adapter == null) {
                return 1;
            }
            RecyclerView.Adapter adapter2 = adapter;
            if (adapter2 instanceof ConcatAdapter) {
                int n2;
                Pair pair = ((ConcatAdapter)adapter2).getWrappedAdapterAndPosition(position);
                Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"adapter.getWrappedAdapterAndPosition(position)");
                Pair pair2 = pair;
                RecyclerView.Adapter wrappedAdapter = (RecyclerView.Adapter)pair2.first;
                if (wrappedAdapter instanceof FullSpanAdapterType) {
                    n2 = QuickGridLayoutManager.this.getSpanCount();
                } else if (wrappedAdapter instanceof BaseQuickAdapter) {
                    Object object = pair2.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.second");
                    int type = wrappedAdapter.getItemViewType(((Number)object).intValue());
                    if (((BaseQuickAdapter)wrappedAdapter).isFullSpanItem(type)) {
                        n2 = QuickGridLayoutManager.this.getSpanCount();
                    } else {
                        GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                        n2 = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
                    }
                } else {
                    GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                    n2 = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
                }
                return n2;
            }
            RecyclerView.Adapter adapter3 = adapter2;
            if (adapter3 instanceof FullSpanAdapterType) {
                n = QuickGridLayoutManager.this.getSpanCount();
            } else if (adapter3 instanceof BaseQuickAdapter) {
                int type = adapter2.getItemViewType(position);
                if (((BaseQuickAdapter)adapter2).isFullSpanItem(type)) {
                    n = QuickGridLayoutManager.this.getSpanCount();
                } else {
                    GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                    n = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
                }
            } else {
                GridLayoutManager.SpanSizeLookup spanSizeLookup = this.originalSpanSizeLookup;
                n = spanSizeLookup != null ? spanSizeLookup.getSpanSize(position) : 1;
            }
            return n;
        }
    }
}

