/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.config;

import com.google.common.reflect.TypeToken;
import io.swagger.annotations.Api;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.config.FilterFactory;
import io.swagger.config.SwaggerConfig;
import io.swagger.core.filter.SwaggerSpecFilter;
import io.swagger.jaxrs.Reader;
import io.swagger.jaxrs.config.AbstractScanner;
import io.swagger.jaxrs.config.SwaggerContextService;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import jakarta.servlet.ServletConfig;
import jakarta.ws.rs.Path;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.scanners.TypeAnnotationsScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanConfig
extends AbstractScanner
implements io.swagger.config.Scanner,
SwaggerConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanConfig.class);
    protected Reader reader = new Reader(new Swagger());
    protected ServletConfig servletConfig;
    String resourcePackage;
    String[] schemes;
    String title;
    String version;
    String description;
    String termsOfServiceUrl;
    String contact;
    String license;
    String licenseUrl;
    String filterClass;
    Info info;
    String host;
    String basePath;
    String scannerId;
    String configId;
    String contextId;
    boolean expandSuperTypes = true;
    private boolean usePathBasedConfig = false;

    public boolean isUsePathBasedConfig() {
        return this.usePathBasedConfig;
    }

    public void setUsePathBasedConfig(boolean usePathBasedConfig) {
        this.usePathBasedConfig = usePathBasedConfig;
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public String[] getSchemes() {
        return this.schemes;
    }

    public void setSchemes(String[] schemes) {
        this.schemes = schemes;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getTermsOfServiceUrl() {
        return this.termsOfServiceUrl;
    }

    public void setTermsOfServiceUrl(String termsOfServiceUrl) {
        this.termsOfServiceUrl = termsOfServiceUrl;
    }

    public String getContact() {
        return this.contact;
    }

    public void setContact(String contact) {
        this.contact = contact;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public String getLicenseUrl() {
        return this.licenseUrl;
    }

    public void setLicenseUrl(String licenseUrl) {
        this.licenseUrl = licenseUrl;
    }

    public Info getInfo() {
        return this.info;
    }

    public void setInfo(Info info) {
        this.info = info;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getFilterClass() {
        return this.filterClass;
    }

    public void setFilterClass(String filterClass) {
        this.filterClass = filterClass;
    }

    public String getContextId() {
        return this.contextId;
    }

    public void setContextId(String contextId) {
        this.contextId = contextId;
    }

    public String getScannerId() {
        return this.scannerId;
    }

    public void setScannerId(String scannerId) {
        this.scannerId = scannerId;
    }

    public String getConfigId() {
        return this.configId;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this.servletConfig = servletConfig;
    }

    public void setConfigId(String configId) {
        this.configId = configId;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public boolean getExpandSuperTypes() {
        return this.expandSuperTypes;
    }

    public void setExpandSuperTypes(boolean expandSuperTypes) {
        this.expandSuperTypes = expandSuperTypes;
    }

    public void setBasePath(String basePath) {
        if (!"".equals(basePath) && basePath != null) {
            this.basePath = !basePath.startsWith("/") ? "/" + basePath : basePath;
        }
    }

    public void setPrettyPrint(String prettyPrint) {
        if (prettyPrint != null) {
            this.prettyPrint = Boolean.parseBoolean(prettyPrint);
        }
    }

    public boolean getScan() {
        return true;
    }

    public void setScan(boolean shouldScan) {
        this.scanAndRead();
        new SwaggerContextService().withConfigId(this.configId).withScannerId(this.scannerId).withContextId(this.contextId).withServletConfig(this.servletConfig).withSwaggerConfig(this).withScanner(this).withBasePath(this.getBasePath()).withPathBasedConfig(this.isUsePathBasedConfig()).initConfig().initScanner();
    }

    public void setScan() {
        this.setScan(true);
    }

    public void scanAndRead() {
        Set<Class<?>> classes = this.classes();
        if (classes != null) {
            Swagger swagger = this.reader.read(classes);
            if (StringUtils.isNotBlank((CharSequence)this.host)) {
                swagger.setHost(this.host);
            }
            if (StringUtils.isNotBlank((CharSequence)this.basePath)) {
                swagger.setBasePath(this.basePath);
            }
            this.updateInfoFromConfig();
        }
    }

    public Set<Class<?>> classes() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        HashSet<String> acceptablePackages = new HashSet<String>();
        boolean allowAllPackages = false;
        if (this.resourcePackage != null && !"".equals(this.resourcePackage)) {
            String[] parts;
            for (String pkg : parts = this.resourcePackage.split(",")) {
                if ("".equals(pkg)) continue;
                acceptablePackages.add(pkg);
                config.addUrls(ClasspathHelper.forPackage((String)pkg, (ClassLoader[])new ClassLoader[0]));
            }
        } else {
            allowAllPackages = true;
        }
        config.setExpandSuperTypes(this.getExpandSuperTypes());
        config.setScanners(new Scanner[]{new ResourcesScanner(), new TypeAnnotationsScanner(), new SubTypesScanner()});
        Reflections reflections = new Reflections((Configuration)config);
        Set classes = reflections.getTypesAnnotatedWith(Path.class);
        Set typesAnnotatedWith = reflections.getTypesAnnotatedWith(SwaggerDefinition.class);
        classes.addAll(typesAnnotatedWith);
        block1: for (Class cls : reflections.getTypesAnnotatedWith(Api.class)) {
            for (Class intfc : TypeToken.of((Class)cls).getTypes().interfaces().rawTypes()) {
                Path ann = intfc.getAnnotation(Path.class);
                if (ann == null) continue;
                classes.add(cls);
                continue block1;
            }
        }
        HashSet output = new HashSet();
        block3: for (Class cls : classes) {
            if (allowAllPackages) {
                output.add(cls);
                continue;
            }
            for (String pkg : acceptablePackages) {
                if (!(cls.getPackage().getName() + ".").startsWith(pkg + ".")) continue;
                output.add(cls);
                continue block3;
            }
        }
        return output;
    }

    private void updateInfoFromConfig() {
        this.info = this.getSwagger().getInfo();
        if (this.info == null) {
            this.info = new Info();
        }
        if (StringUtils.isNotBlank((CharSequence)this.description)) {
            this.info.description(this.description);
        }
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            this.info.title(this.title);
        }
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            this.info.version(this.version);
        }
        if (StringUtils.isNotBlank((CharSequence)this.termsOfServiceUrl)) {
            this.info.termsOfService(this.termsOfServiceUrl);
        }
        if (this.contact != null) {
            this.info.contact(new Contact().name(this.contact));
        }
        if (this.license != null && this.licenseUrl != null) {
            this.info.license(new License().name(this.license).url(this.licenseUrl));
        }
        if (this.schemes != null) {
            for (String scheme : this.schemes) {
                this.reader.getSwagger().scheme(Scheme.forValue((String)scheme));
            }
        }
        this.reader.getSwagger().setInfo(this.info);
    }

    public Swagger getSwagger() {
        return this.reader.getSwagger();
    }

    public Swagger configure(Swagger swagger) {
        if (this.schemes != null) {
            for (String scheme : this.schemes) {
                swagger.scheme(Scheme.forValue((String)scheme));
            }
        }
        if (this.filterClass != null) {
            try {
                SwaggerSpecFilter filter = (SwaggerSpecFilter)Class.forName(this.filterClass).newInstance();
                if (filter != null) {
                    FilterFactory.setFilter((SwaggerSpecFilter)filter);
                }
            }
            catch (Exception e) {
                LOGGER.error("failed to load filter", (Throwable)e);
            }
        }
        return swagger.info(this.info).host(this.host).basePath(this.basePath);
    }
}

