/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.jaxrs.config;

import io.swagger.jaxrs.config.DefaultReaderConfig;
import io.swagger.jaxrs.config.ReaderConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import java.util.LinkedHashSet;
import org.apache.commons.lang3.StringUtils;

public class ReaderConfigUtils {
    private ReaderConfigUtils() {
    }

    public static void initReaderConfig(ServletConfig config) {
        if ("true".equals(config.getInitParameter("scan.all.resources"))) {
            DefaultReaderConfig rc = new DefaultReaderConfig();
            rc.setScanAllResources(true);
            LinkedHashSet<String> ignoredRoutes = new LinkedHashSet<String>();
            for (String item : StringUtils.trimToEmpty((String)config.getInitParameter("ignore.routes")).split(",")) {
                String route = StringUtils.trimToNull((String)item);
                if (route == null) continue;
                ignoredRoutes.add(route);
            }
            rc.setIgnoredRoutes(ignoredRoutes);
            config.getServletContext().setAttribute(ReaderConfigUtils.getAttributeName(), (Object)rc);
        }
    }

    public static ReaderConfig getReaderConfig(ServletContext context) {
        if (context == null) {
            return null;
        }
        Object attr = context.getAttribute(ReaderConfigUtils.getAttributeName());
        if (attr instanceof ReaderConfig) {
            return (ReaderConfig)attr;
        }
        return null;
    }

    private static String getAttributeName() {
        return ReaderConfig.class.getName();
    }
}

