/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.github.kongchen.swagger.docgen.jaxrs.BeanParamInjectParamExtension;
import com.github.kongchen.swagger.docgen.jaxrs.JaxrsParameterExtension;
import com.github.kongchen.swagger.docgen.reader.AbstractReader;
import com.github.kongchen.swagger.docgen.reader.ClassSwaggerReader;
import com.github.kongchen.swagger.docgen.reader.ResponseContainerConverter;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.AuthorizationScope;
import io.swagger.annotations.Extension;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.converter.ModelConverters;
import io.swagger.jaxrs.PATCH;
import io.swagger.jaxrs.ext.AbstractSwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtension;
import io.swagger.jaxrs.ext.SwaggerExtensions;
import io.swagger.jersey.SwaggerJerseyJaxrs;
import io.swagger.models.ArrayModel;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.SecurityRequirement;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.models.refs.RefType;
import io.swagger.util.BaseReaderUtils;
import io.swagger.util.ReflectionUtils;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HEAD;
import jakarta.ws.rs.HttpMethod;
import jakarta.ws.rs.OPTIONS;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.logging.Log;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class JaxrsReader
extends AbstractReader
implements ClassSwaggerReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(JaxrsReader.class);
    private static final ResponseContainerConverter RESPONSE_CONTAINER_CONVERTER = new ResponseContainerConverter();

    public JaxrsReader(Swagger swagger, Log LOG) {
        super(swagger, LOG);
    }

    @Override
    protected void updateExtensionChain() {
        ArrayList<AbstractSwaggerExtension> extensions = new ArrayList<AbstractSwaggerExtension>();
        extensions.add(new BeanParamInjectParamExtension(this));
        extensions.add((AbstractSwaggerExtension)new SwaggerJerseyJaxrs());
        extensions.add(new JaxrsParameterExtension());
        SwaggerExtensions.setExtensions(extensions);
    }

    @Override
    public Swagger read(Set<Class<?>> classes) {
        for (Class<?> cls : classes) {
            this.read(cls);
        }
        return this.swagger;
    }

    public Swagger getSwagger() {
        return this.swagger;
    }

    public Swagger read(Class<?> cls) {
        return this.read(cls, "", null, false, new String[0], new String[0], new HashMap<String, Tag>(), new ArrayList<Parameter>());
    }

    protected Swagger read(Class<?> cls, String parentPath, String parentMethod, boolean readHidden, String[] parentConsumes, String[] parentProduces, Map<String, Tag> parentTags, List<Parameter> parentParameters) {
        if (this.swagger == null) {
            this.swagger = new Swagger();
        }
        Api api = (Api)AnnotationUtils.findAnnotation(cls, Api.class);
        Path apiPath = (Path)AnnotationUtils.findAnnotation(cls, Path.class);
        if (!this.canReadApi(readHidden, api)) {
            return this.swagger;
        }
        Map<String, Tag> tags = this.updateTagsForApi(parentTags, api);
        List<SecurityRequirement> securities = this.getSecurityRequirements(api);
        Map<String, Tag> discoveredTags = this.scanClasspathForTags();
        this.readCommonParameters(cls);
        List<Method> filteredMethods = this.getFilteredMethods(cls);
        for (Method method : filteredMethods) {
            String operationPath;
            ApiOperation apiOperation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class);
            if (apiOperation != null && apiOperation.hidden()) continue;
            Path methodPath = (Path)AnnotationUtils.findAnnotation((Method)method, Path.class);
            String parentPathValue = String.valueOf(parentPath);
            if (apiPath == null && methodPath == null && parentPath != null && readHidden) {
                Path path;
                final String updatedMethodPath = String.valueOf(parentPath);
                methodPath = path = new Path(){

                    public String value() {
                        return updatedMethodPath;
                    }

                    public Class<? extends Annotation> annotationType() {
                        return Path.class;
                    }
                };
                parentPathValue = null;
            }
            if ((operationPath = this.getPath(apiPath, methodPath, parentPathValue)) != null) {
                Produces produces;
                HashMap<String, String> regexMap = new HashMap<String, String>();
                operationPath = this.parseOperationPath(operationPath, regexMap);
                String httpMethod = this.extractOperationMethod(apiOperation, method, SwaggerExtensions.chain());
                Operation operation = this.parseMethod(httpMethod, method);
                this.updateOperationParameters(parentParameters, regexMap, operation);
                this.updateOperationProtocols(apiOperation, operation);
                String[] apiConsumes = new String[]{};
                String[] apiProduces = new String[]{};
                Consumes consumes = (Consumes)AnnotationUtils.findAnnotation(cls, Consumes.class);
                if (consumes != null) {
                    apiConsumes = consumes.value();
                }
                if ((produces = (Produces)AnnotationUtils.findAnnotation(cls, Produces.class)) != null) {
                    apiProduces = produces.value();
                }
                apiConsumes = this.updateOperationConsumes(parentConsumes, apiConsumes, operation);
                apiProduces = this.updateOperationProduces(parentProduces, apiProduces, operation);
                this.handleSubResource(apiConsumes, httpMethod, apiProduces, tags, method, apiOperation, operationPath, operation);
                httpMethod = httpMethod == null ? parentMethod : httpMethod;
                this.updateTagsForOperation(operation, apiOperation);
                this.updateOperation(apiConsumes, apiProduces, tags, securities, operation);
                this.updatePath(operationPath, httpMethod, operation);
            }
            this.updateTagDescriptions(discoveredTags);
        }
        return this.swagger;
    }

    private List<Method> getFilteredMethods(Class<?> cls) {
        Method[] methods = cls.getMethods();
        ArrayList<Method> filteredMethods = new ArrayList<Method>();
        for (Method method : methods) {
            if (method.isBridge()) continue;
            filteredMethods.add(method);
        }
        return filteredMethods;
    }

    private boolean hasCommonParameter(Parameter parameter) {
        Parameter commonParameter = this.swagger.getParameter(parameter.getName());
        return commonParameter != null && parameter.getIn().equals(commonParameter.getIn());
    }

    private void readCommonParameters(Class<?> cls) {
        Field[] fields;
        Path path = (Path)AnnotationUtils.findAnnotation(cls, Path.class);
        if (path != null) {
            return;
        }
        List<Method> filteredMethods = this.getFilteredMethods(cls);
        for (Method method : filteredMethods) {
            path = (Path)AnnotationUtils.findAnnotation((Method)method, Path.class);
            if (path != null) {
                return;
            }
            String httpMethod = this.extractOperationMethod(null, method, SwaggerExtensions.chain());
            if (httpMethod == null) continue;
            return;
        }
        for (Field field : fields = cls.getDeclaredFields()) {
            Annotation[] annotations = field.getAnnotations();
            if (annotations.length <= 0) continue;
            List<Parameter> params = this.getParameters(cls, Arrays.asList(annotations));
            for (Parameter param : params) {
                if (this.hasCommonParameter(param)) {
                    String msg = "[" + cls.getCanonicalName() + "] Redefining common parameter '" + param.getName() + "' already defined elsewhere";
                    throw new RuntimeException(msg);
                }
                this.swagger.addParameter(param.getName(), param);
            }
        }
    }

    private void updateTagDescriptions(Map<String, Tag> discoveredTags) {
        if (this.swagger.getTags() != null) {
            for (Tag tag : this.swagger.getTags()) {
                Tag rightTag = discoveredTags.get(tag.getName());
                if (rightTag == null || rightTag.getDescription() == null) continue;
                tag.setDescription(rightTag.getDescription());
            }
        }
    }

    private Map<String, Tag> scanClasspathForTags() {
        HashMap<String, Tag> tags = new HashMap<String, Tag>();
        for (Class aClass : new Reflections("", new Scanner[0]).getTypesAnnotatedWith(SwaggerDefinition.class)) {
            SwaggerDefinition swaggerDefinition = (SwaggerDefinition)AnnotationUtils.findAnnotation((Class)aClass, SwaggerDefinition.class);
            for (io.swagger.annotations.Tag tag : swaggerDefinition.tags()) {
                String tagName = tag.name();
                if (tagName.isEmpty()) continue;
                tags.put(tag.name(), new Tag().name(tag.name()).description(tag.description()));
            }
        }
        return tags;
    }

    private void handleSubResource(String[] apiConsumes, String httpMethod, String[] apiProduces, Map<String, Tag> tags, Method method, ApiOperation apiOperation, String operationPath, Operation operation) {
        if (this.isSubResource(httpMethod, method)) {
            Class responseClass = method.getReturnType();
            if (apiOperation != null && !apiOperation.response().equals(Void.class) && !apiOperation.response().equals(Void.TYPE)) {
                responseClass = apiOperation.response();
            }
            LOGGER.debug("handling sub-resource method " + method.toString() + " -> " + responseClass);
            this.read(responseClass, operationPath, httpMethod, true, apiConsumes, apiProduces, tags, operation.getParameters());
        }
    }

    protected boolean isSubResource(String httpMethod, Method method) {
        Class<?> responseClass = method.getReturnType();
        return responseClass != null && httpMethod == null && AnnotationUtils.findAnnotation((Method)method, Path.class) != null;
    }

    private String getPath(Path classLevelPath, Path methodLevelPath, String parentPath) {
        String output;
        if (classLevelPath == null && methodLevelPath == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (parentPath != null && !parentPath.isEmpty() && !parentPath.equals("/")) {
            if (!parentPath.startsWith("/")) {
                parentPath = "/" + parentPath;
            }
            if (parentPath.endsWith("/")) {
                parentPath = parentPath.substring(0, parentPath.length() - 1);
            }
            stringBuilder.append(parentPath);
        }
        if (classLevelPath != null) {
            stringBuilder.append(classLevelPath.value());
        }
        if (methodLevelPath != null && !methodLevelPath.value().equals("/")) {
            String methodPath = methodLevelPath.value();
            if (!methodPath.startsWith("/") && !stringBuilder.toString().endsWith("/")) {
                stringBuilder.append("/");
            }
            if (methodPath.endsWith("/")) {
                methodPath = methodPath.substring(0, methodPath.length() - 1);
            }
            stringBuilder.append(methodPath);
        }
        if (!(output = stringBuilder.toString()).startsWith("/")) {
            output = "/" + output;
        }
        if (output.endsWith("/") && output.length() > 1) {
            return output.substring(0, output.length() - 1);
        }
        return output;
    }

    public Operation parseMethod(String httpMethod, Method method) {
        ApiResponses apiResponses;
        Produces produces;
        Consumes consumes;
        int responseCode = 200;
        Operation operation = new Operation();
        ApiOperation apiOperation = (ApiOperation)AnnotationUtils.findAnnotation((Method)method, ApiOperation.class);
        String operationId = this.getOperationId(method, httpMethod);
        String responseContainer = null;
        Object responseClassType = null;
        Map<String, Property> defaultResponseHeaders = null;
        if (apiOperation != null) {
            if (apiOperation.hidden()) {
                return null;
            }
            if (!apiOperation.nickname().isEmpty()) {
                operationId = apiOperation.nickname();
            }
            defaultResponseHeaders = this.parseResponseHeaders(apiOperation.responseHeaders());
            operation.summary(apiOperation.value()).description(apiOperation.notes());
            Map customExtensions = BaseReaderUtils.parseExtensions((Extension[])apiOperation.extensions());
            operation.setVendorExtensions(customExtensions);
            if (!apiOperation.response().equals(Void.class) && !apiOperation.response().equals(Void.TYPE)) {
                responseClassType = apiOperation.response();
            }
            if (!apiOperation.responseContainer().isEmpty()) {
                responseContainer = apiOperation.responseContainer();
            }
            ArrayList<SecurityRequirement> securities = new ArrayList<SecurityRequirement>();
            for (Authorization auth : apiOperation.authorizations()) {
                if (auth.value().isEmpty()) continue;
                SecurityRequirement security = new SecurityRequirement();
                security.setName(auth.value());
                for (AuthorizationScope scope : auth.scopes()) {
                    if (scope.scope().isEmpty()) continue;
                    security.addScope(scope.scope());
                }
                securities.add(security);
            }
            for (SecurityRequirement securityRequirement : securities) {
                operation.security(securityRequirement);
            }
        }
        operation.operationId(operationId);
        if (responseClassType == null) {
            LOGGER.debug("picking up response class from method " + method);
            responseClassType = method.getGenericReturnType();
        }
        boolean hasApiAnnotation = false;
        if (responseClassType instanceof Class) {
            boolean bl = hasApiAnnotation = AnnotationUtils.findAnnotation((Class)((Class)responseClassType), Api.class) != null;
        }
        if (!(responseClassType == null || responseClassType.equals(Void.class) || responseClassType.equals(Void.TYPE) || responseClassType.equals(Response.class) || hasApiAnnotation || this.isSubResource(httpMethod, method))) {
            Map models;
            if (this.isPrimitive((Type)responseClassType)) {
                Property property = ModelConverters.getInstance().readAsProperty((Type)responseClassType);
                if (property != null) {
                    Property responseProperty = RESPONSE_CONTAINER_CONVERTER.withResponseContainer(responseContainer, property);
                    operation.response(responseCode, new io.swagger.models.Response().description("successful operation").schema(responseProperty).headers(defaultResponseHeaders));
                }
            } else if (!responseClassType.equals(Void.class) && !responseClassType.equals(Void.TYPE)) {
                models = ModelConverters.getInstance().read((Type)responseClassType);
                if (models.isEmpty()) {
                    Property p = ModelConverters.getInstance().readAsProperty((Type)responseClassType);
                    operation.response(responseCode, new io.swagger.models.Response().description("successful operation").schema(p).headers(defaultResponseHeaders));
                }
                for (String string : models.keySet()) {
                    Property responseProperty = RESPONSE_CONTAINER_CONVERTER.withResponseContainer(responseContainer, (Property)new RefProperty().asDefault(string));
                    operation.response(responseCode, new io.swagger.models.Response().description("successful operation").schema(responseProperty).headers(defaultResponseHeaders));
                    this.swagger.model(string, (Model)models.get(string));
                }
            }
            models = this.readAllModels((Type)responseClassType);
            for (Map.Entry entry : models.entrySet()) {
                this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
            }
        }
        if ((consumes = (Consumes)AnnotationUtils.findAnnotation((Method)method, Consumes.class)) != null) {
            for (String mediaType : consumes.value()) {
                operation.consumes(mediaType);
            }
        }
        if ((produces = (Produces)AnnotationUtils.findAnnotation((Method)method, Produces.class)) != null) {
            for (String mediaType : produces.value()) {
                operation.produces(mediaType);
            }
        }
        if ((apiResponses = (ApiResponses)AnnotationUtils.findAnnotation((Method)method, ApiResponses.class)) != null) {
            this.updateApiResponse(operation, apiResponses);
        }
        this.overrideResponseMessages(operation);
        if (AnnotationUtils.findAnnotation((Method)method, Deprecated.class) != null) {
            operation.deprecated(Boolean.valueOf(true));
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        Annotation[][] paramAnnotations = JaxrsReader.findParamAnnotations(method);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type type = genericParameterTypes[i];
            List<Annotation> annotations = Arrays.asList(paramAnnotations[i]);
            List<Parameter> parameters = this.getParameters(type, annotations);
            for (Parameter parameter : parameters) {
                if (this.hasCommonParameter(parameter)) {
                    RefParameter refParameter = new RefParameter(RefType.PARAMETER.getInternalPrefix() + parameter.getName());
                    operation.parameter((Parameter)refParameter);
                    continue;
                }
                parameter = this.replaceArrayModelForOctetStream(operation, parameter);
                operation.parameter(parameter);
            }
        }
        if (operation.getResponses() == null) {
            operation.defaultResponse(new io.swagger.models.Response().description("successful operation"));
        }
        this.readImplicitParameters(method, operation);
        this.processOperationDecorator(operation, method);
        return operation;
    }

    public static Annotation[][] findParamAnnotations(Method method) {
        Annotation[][] paramAnnotation = method.getParameterAnnotations();
        Method overriddenMethod = ReflectionUtils.getOverriddenMethod((Method)method);
        while (overriddenMethod != null) {
            paramAnnotation = JaxrsReader.merge(overriddenMethod.getParameterAnnotations(), paramAnnotation);
            overriddenMethod = ReflectionUtils.getOverriddenMethod((Method)overriddenMethod);
        }
        return paramAnnotation;
    }

    private static Annotation[][] merge(Annotation[][] overriddenMethodParamAnnotation, Annotation[][] currentParamAnnotations) {
        Annotation[][] mergedAnnotations = new Annotation[overriddenMethodParamAnnotation.length][];
        for (int i = 0; i < overriddenMethodParamAnnotation.length; ++i) {
            mergedAnnotations[i] = JaxrsReader.merge(overriddenMethodParamAnnotation[i], currentParamAnnotations[i]);
        }
        return mergedAnnotations;
    }

    private static Annotation[] merge(Annotation[] annotations, Annotation[] annotations2) {
        ArrayList<Annotation> mergedAnnotations = new ArrayList<Annotation>();
        mergedAnnotations.addAll(Arrays.asList(annotations));
        mergedAnnotations.addAll(Arrays.asList(annotations2));
        return mergedAnnotations.toArray(new Annotation[0]);
    }

    private Parameter replaceArrayModelForOctetStream(Operation operation, Parameter parameter) {
        ArrayModel arrayModel;
        Property items;
        BodyParameter bodyParam;
        Model schema;
        if (parameter instanceof BodyParameter && operation.getConsumes() != null && operation.getConsumes().contains("application/octet-stream") && (schema = (bodyParam = (BodyParameter)parameter).getSchema()) instanceof ArrayModel && (items = (arrayModel = (ArrayModel)schema).getItems()) != null && items.getFormat() == "byte" && items.getType() == "string") {
            ModelImpl model = new ModelImpl();
            model.setFormat("byte");
            model.setType("string");
            bodyParam.setSchema((Model)model);
        }
        return parameter;
    }

    public String extractOperationMethod(ApiOperation apiOperation, Method method, Iterator<SwaggerExtension> chain) {
        if (apiOperation != null && !apiOperation.httpMethod().isEmpty()) {
            return apiOperation.httpMethod().toLowerCase();
        }
        if (AnnotationUtils.findAnnotation((Method)method, GET.class) != null) {
            return "get";
        }
        if (AnnotationUtils.findAnnotation((Method)method, PUT.class) != null) {
            return "put";
        }
        if (AnnotationUtils.findAnnotation((Method)method, POST.class) != null) {
            return "post";
        }
        if (AnnotationUtils.findAnnotation((Method)method, DELETE.class) != null) {
            return "delete";
        }
        if (AnnotationUtils.findAnnotation((Method)method, OPTIONS.class) != null) {
            return "options";
        }
        if (AnnotationUtils.findAnnotation((Method)method, HEAD.class) != null) {
            return "head";
        }
        if (AnnotationUtils.findAnnotation((Method)method, PATCH.class) != null) {
            return "patch";
        }
        for (Annotation declaredAnnotation : method.getDeclaredAnnotations()) {
            Annotation[] innerAnnotations;
            for (Annotation innerAnnotation : innerAnnotations = declaredAnnotation.annotationType().getAnnotations()) {
                if (!(innerAnnotation instanceof HttpMethod)) continue;
                HttpMethod httpMethod = (HttpMethod)innerAnnotation;
                return httpMethod.value().toLowerCase();
            }
        }
        if (chain.hasNext()) {
            return chain.next().extractOperationMethod(apiOperation, method, chain);
        }
        return null;
    }

    private Map<String, Model> readAllModels(Type responseClassType) {
        Map modelMap = ModelConverters.getInstance().readAll(responseClassType);
        if (modelMap != null) {
            this.handleJsonTypeInfo(responseClassType, modelMap);
        }
        return modelMap;
    }

    private void handleJsonTypeInfo(Type responseClassType, Map<String, Model> modelMap) {
        if (responseClassType instanceof ParameterizedType) {
            Type[] actualTypes;
            for (Type type : actualTypes = ((ParameterizedType)responseClassType).getActualTypeArguments()) {
                this.handleJsonTypeInfo(type, modelMap);
            }
        } else if (responseClassType instanceof Class) {
            JsonTypeInfo typeInfo;
            Class<?> responseClass = (Class<?>)responseClassType;
            if (responseClass.isArray()) {
                responseClass = responseClass.getComponentType();
            }
            if ((typeInfo = responseClass.getAnnotation(JsonTypeInfo.class)) == null || StringUtils.isEmpty((CharSequence)typeInfo.property()) || typeInfo.include().equals((Object)JsonTypeInfo.As.EXISTING_PROPERTY)) {
                return;
            }
            Map properties = modelMap.get(responseClass.getSimpleName()).getProperties();
            if (properties != null && !properties.containsKey(typeInfo.property())) {
                properties.put(typeInfo.property(), new StringProperty());
            }
        }
    }
}

