/*
 * Decompiled with CFR 0.152.
 */
package com.github.kongchen.swagger.docgen.reader;

import com.github.kongchen.swagger.docgen.reader.JaxrsReader;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.converter.ModelConverters;
import io.swagger.models.Model;
import io.swagger.models.Operation;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import java.io.File;
import java.lang.reflect.Type;
import java.util.Map;
import org.apache.maven.plugin.logging.Log;

public class JaxrsReaderWithFileDownloadSupport
extends JaxrsReader {
    public JaxrsReaderWithFileDownloadSupport(Swagger swagger, Log log) {
        super(swagger, log);
    }

    @Override
    protected void updateApiResponse(Operation operation, ApiResponses responseAnnotation) {
        for (ApiResponse apiResponse : responseAnnotation.value()) {
            Map<String, Property> responseHeaders = this.parseResponseHeaders(apiResponse.responseHeaders());
            Class responseClass = apiResponse.response();
            Response response = new Response().description(apiResponse.message()).headers(responseHeaders);
            if (responseClass.equals(File.class)) {
                response.schema((Property)new FileProperty());
            }
            if (responseClass.equals(Void.class)) {
                this.voidResponseType(operation, apiResponse, response);
            } else {
                this.otherResponseTypes(operation, apiResponse, response);
            }
            if (apiResponse.code() == 0) {
                operation.defaultResponse(response);
                continue;
            }
            operation.response(apiResponse.code(), response);
        }
    }

    private void voidResponseType(Operation operation, ApiResponse apiResponse, Response response) {
        Response apiOperationResponse;
        if (operation.getResponses() != null && (apiOperationResponse = (Response)operation.getResponses().get(String.valueOf(apiResponse.code()))) != null) {
            response.schema(apiOperationResponse.getSchema());
        }
    }

    private void otherResponseTypes(Operation operation, ApiResponse apiResponse, Response response) {
        Class responseClass = apiResponse.response();
        Map models = ModelConverters.getInstance().read((Type)responseClass);
        for (Map.Entry entry : models.entrySet()) {
            RefProperty schema = new RefProperty().asDefault((String)entry.getKey());
            if ("List".equals(apiResponse.responseContainer())) {
                response.schema((Property)new ArrayProperty((Property)schema));
            } else {
                response.schema((Property)schema);
            }
            this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
        models = ModelConverters.getInstance().readAll((Type)responseClass);
        for (Map.Entry entry : models.entrySet()) {
            this.swagger.model((String)entry.getKey(), (Model)entry.getValue());
        }
        if (response.getSchema() == null) {
            this.voidResponseType(operation, apiResponse, response);
        }
    }
}

