/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.servlet.config;

import io.swagger.annotations.Api;
import jakarta.servlet.ServletConfig;
import java.util.Set;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class ServletScanner
implements io.swagger.config.Scanner {
    private boolean prettyPrint = false;
    private String resourcePackage;

    public ServletScanner(ServletConfig servletConfig) {
        this.resourcePackage = servletConfig.getInitParameter("swagger.resource.package");
        String shouldPrettyPrint = servletConfig.getInitParameter("swagger.pretty.print");
        if (shouldPrettyPrint != null) {
            this.prettyPrint = Boolean.parseBoolean(shouldPrettyPrint);
        }
    }

    public String getResourcePackage() {
        return this.resourcePackage;
    }

    public void setResourcePackage(String resourcePackage) {
        this.resourcePackage = resourcePackage;
    }

    public Set<Class<?>> classes() {
        return new Reflections(this.resourcePackage, new Scanner[0]).getTypesAnnotatedWith(Api.class);
    }

    public boolean getPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean shouldPrettyPrint) {
        this.prettyPrint = shouldPrettyPrint;
    }
}

