/*
 * Decompiled with CFR 0.152.
 */
package io.github.cyzest.commons.spring.dao;

import io.github.cyzest.commons.spring.model.EnumCode;
import javax.persistence.AttributeConverter;

public abstract class EnumCodeConverter<T extends Enum<T>>
implements AttributeConverter<T, String> {
    private final Class<T> targetClass;

    public EnumCodeConverter(Class<T> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException();
        }
        this.targetClass = targetClass;
    }

    public String convertToDatabaseColumn(T attribute) {
        return attribute != null ? ((EnumCode)attribute).getCode() : null;
    }

    public T convertToEntityAttribute(String result) {
        Enum enumType = null;
        if (result != null && !result.isEmpty()) {
            Enum[] constants;
            for (Enum constant : constants = (Enum[])this.targetClass.getEnumConstants()) {
                if (!((EnumCode)((Object)constant)).getCode().equals(result)) continue;
                enumType = constant;
                break;
            }
        }
        return (T)enumType;
    }
}

