/*
 * Decompiled with CFR 0.152.
 */
package io.github.cyzest.commons.spring.dao;

import io.github.cyzest.commons.spring.model.EnumCode;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

public abstract class EnumCodeHandler<T extends Enum<T>>
implements TypeHandler<T> {
    private final Class<T> targetClass;

    public EnumCodeHandler(Class<T> targetClass) {
        if (targetClass == null) {
            throw new IllegalArgumentException();
        }
        this.targetClass = targetClass;
    }

    public void setParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, ((EnumCode)parameter).getCode());
    }

    public T getResult(ResultSet rs, String columnName) throws SQLException {
        String result = rs.getString(columnName);
        return this.getEnumTypeByResult(result);
    }

    public T getResult(ResultSet rs, int columnIndex) throws SQLException {
        String result = rs.getString(columnIndex);
        return this.getEnumTypeByResult(result);
    }

    public T getResult(CallableStatement cs, int columnIndex) throws SQLException {
        String result = cs.getString(columnIndex);
        return this.getEnumTypeByResult(result);
    }

    private T getEnumTypeByResult(String result) {
        Enum enumCode = null;
        if (result != null && !result.isEmpty()) {
            Enum[] constants;
            for (Enum constant : constants = (Enum[])this.targetClass.getEnumConstants()) {
                if (!((EnumCode)((Object)constant)).getCode().equals(result)) continue;
                enumCode = constant;
                break;
            }
        }
        return (T)enumCode;
    }
}

