/*
 * Decompiled with CFR 0.152.
 */
package io.github.cyzest.commons.spring.dao.apt;

import io.github.cyzest.commons.spring.dao.apt.JpaEnumCodeConverter;
import io.github.cyzest.commons.spring.dao.apt.MybatisEnumCodeHandler;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.tools.JavaFileObject;

public class EnumCodeAnnotationProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (annotations.isEmpty()) {
            return true;
        }
        for (TypeElement typeElement : annotations) {
            if (typeElement.toString().equals(JpaEnumCodeConverter.class.getName())) {
                this.generateEnumCodeConverter(roundEnv, typeElement);
                continue;
            }
            if (!typeElement.toString().equals(MybatisEnumCodeHandler.class.getName())) continue;
            this.generateEnumCodeHandler(roundEnv, typeElement);
        }
        return true;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add(JpaEnumCodeConverter.class.getName());
        supportedAnnotationTypes.add(MybatisEnumCodeHandler.class.getName());
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    private void generateEnumCodeConverter(RoundEnvironment roundEnv, TypeElement typeElement) {
        for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
            Name className = element.getSimpleName();
            String source = "package " + element.getEnclosingElement() + ";\r\nimport io.github.cyzest.commons.spring.dao.EnumCodeConverter;\r\nimport javax.persistence.Converter;\r\n@Converter(autoApply = true)\r\npublic class " + className + "EnumCodeConverter extends EnumCodeConverter<" + className + "> {\r\npublic " + className + "EnumCodeConverter() {\r\nsuper(" + className + ".class);\r\n}\r\n}\r\n";
            this.createSourceFile(element + "EnumCodeConverter", source);
        }
    }

    private void generateEnumCodeHandler(RoundEnvironment roundEnv, TypeElement typeElement) {
        for (Element element : roundEnv.getElementsAnnotatedWith(typeElement)) {
            Name className = element.getSimpleName();
            String source = "package " + element.getEnclosingElement() + ";\r\nimport io.github.cyzest.commons.spring.dao.EnumCodeHandler;\r\nimport org.apache.ibatis.type.MappedTypes;\r\n@MappedTypes(" + className + ".class)\r\npublic class " + className + "EnumCodeHandler extends EnumCodeHandler<" + className + "> {\r\npublic " + className + "EnumCodeHandler() {\r\nsuper(" + className + ".class);\r\n}\r\n}\r\n";
            this.createSourceFile(element + "EnumCodeHandler", source);
        }
    }

    private void createSourceFile(String sourcePath, String source) {
        try {
            Filer filer = this.processingEnv.getFiler();
            JavaFileObject javaFile = filer.createSourceFile(sourcePath, new Element[0]);
            try (Writer writer = javaFile.openWriter();){
                writer.write(source);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }
}

