/*
 * Decompiled with CFR 0.152.
 */
package io.github.cyzest.commons.spring.validator;

import io.github.cyzest.commons.spring.validator.FileTypeValidator;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.tika.Tika;
import org.springframework.web.multipart.MultipartFile;

public class FileTypeConstraintValidator
implements ConstraintValidator<FileTypeValidator, MultipartFile> {
    private FileTypeValidator fileTypeValidator;
    private Set<String> mimeTypeSet = null;
    private final Tika tika = new Tika();

    public void initialize(FileTypeValidator constraintAnnotation) {
        this.fileTypeValidator = constraintAnnotation;
        String[] mimeTypes = this.fileTypeValidator.mimeTypes();
        if (mimeTypes.length > 0) {
            this.mimeTypeSet = new HashSet<String>();
            this.mimeTypeSet.addAll(Arrays.asList(mimeTypes));
        }
    }

    public boolean isValid(MultipartFile file, ConstraintValidatorContext context) {
        boolean result = true;
        if (this.mimeTypeSet != null && file != null) {
            try (InputStream is = file.getInputStream();){
                String mimeType = this.tika.detect(is);
                if (!this.mimeTypeSet.contains(mimeType)) {
                    result = false;
                }
            }
            catch (Throwable ex) {
                result = false;
            }
        }
        if (!result) {
            context.disableDefaultConstraintViolation();
            context.buildConstraintViolationWithTemplate(this.fileTypeValidator.message()).addBeanNode().addConstraintViolation();
        }
        return result;
    }
}

