/*
 * Decompiled with CFR 0.152.
 */
package io.github.cyzest.commons.spring.web;

import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;

public class ApiResponse {
    private int code;
    private String message;
    private Object extra;

    public ApiResponse() {
        this.code = HttpStatus.OK.value();
        this.message = HttpStatus.OK.getReasonPhrase();
    }

    public ApiResponse(int code, String message) {
        this.code = code;
        this.message = message;
    }

    public ApiResponse(HttpStatus httpStatus) {
        Assert.notNull((Object)httpStatus, (String)"httpStatus must not be null");
        this.code = httpStatus.value();
        this.message = httpStatus.getReasonPhrase();
    }

    public String toString() {
        return "ApiResponse{code=" + this.code + ", message='" + this.message + '\'' + ", extra=" + this.extra + '}';
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public Object getExtra() {
        return this.extra;
    }

    public void setExtra(Object extra) {
        this.extra = extra;
    }

    public void putExtra(String key, Object value) {
        if (!(this.extra instanceof Map)) {
            this.extra = new LinkedHashMap();
        }
        Map map = (Map)this.extra;
        map.put(key, value);
    }
}

