/*
 * Decompiled with CFR 0.152.
 */
package api.link.checker.controller;

import api.link.checker.core.ApiCheckRepository;
import api.link.checker.core.ApiInfo;
import api.link.checker.core.SwaggerService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/api/link/checker"})
public class TrackedApiController {
    private final ApiCheckRepository apiCheckRepository;
    private final SwaggerService swaggerService;

    public TrackedApiController(ApiCheckRepository apiCheckRepository, SwaggerService swaggerService) {
        this.apiCheckRepository = apiCheckRepository;
        this.swaggerService = swaggerService;
    }

    @GetMapping
    public Map<String, List<ApiInfo>> getAllGroupedApis() {
        return this.apiCheckRepository.getAllGroupedApis();
    }

    @GetMapping(value={"/check"})
    public void updateCheckStatus(@RequestParam(value="httpMethod") String httpMethod, @RequestParam(value="path") String path, @RequestParam(value="nickname") String nickname, @RequestParam(value="checked") boolean checked) {
        this.apiCheckRepository.updateCheckStatus(httpMethod, path, nickname, checked);
    }

    @GetMapping(value={"/swagger-links"})
    public Map<String, String> getSwaggerLinks() throws IOException {
        return this.swaggerService.fetchSwaggerLinks(this.apiCheckRepository.getAllGroupedApis());
    }
}

