/*
 * Decompiled with CFR 0.152.
 */
package api.link.checker.core;

import api.link.checker.core.ApiInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Repository;

@Repository
public class ApiCheckRepository {
    private final Map<String, List<ApiInfo>> groupedApiMap = new HashMap<String, List<ApiInfo>>();
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final String filePath;

    public ApiCheckRepository(@Value(value="${api.checker.storage.filepath:api-status.json}") String filePath) {
        this.filePath = filePath;
        this.loadFromFile();
    }

    public void initializeApis(Map<String, List<ApiInfo>> groupedApis) {
        Set<String> newGroupNames = groupedApis.keySet();
        this.groupedApiMap.keySet().removeIf(groupName -> !newGroupNames.contains(groupName));
        groupedApis.forEach((groupName, apiList) -> {
            List existingApiList = this.groupedApiMap.getOrDefault(groupName, new ArrayList());
            Map<String, ApiInfo> existingApiMap = existingApiList.stream().collect(Collectors.toMap(api -> api.getHttpMethod() + "_" + api.getPath(), api -> api));
            ArrayList<ApiInfo> finalApiList = new ArrayList<ApiInfo>();
            for (ApiInfo api2 : apiList) {
                String key = api2.getHttpMethod() + "_" + api2.getPath();
                if (existingApiMap.containsKey(key)) {
                    api2.setChecked(existingApiMap.get(key).isChecked());
                }
                finalApiList.add(api2);
            }
            this.groupedApiMap.put((String)groupName, (List<ApiInfo>)finalApiList);
        });
        this.saveToFile();
    }

    public void updateCheckStatus(String httpMethod, String path, String nickname, boolean checked) {
        this.groupedApiMap.values().forEach(apiList -> apiList.stream().filter(apiInfo -> apiInfo.getPath().equals(path) && apiInfo.getHttpMethod().equalsIgnoreCase(httpMethod)).findFirst().ifPresent(apiInfo -> {
            apiInfo.setNickname(checked ? nickname : "");
            apiInfo.setChecked(checked);
        }));
        this.saveToFile();
    }

    public Map<String, List<ApiInfo>> getAllGroupedApis() {
        return this.groupedApiMap;
    }

    private void loadFromFile() {
        File file = new File(this.filePath);
        if (file.exists()) {
            try {
                Map savedData = (Map)this.objectMapper.readValue(file, (TypeReference)new TypeReference<Map<String, List<ApiInfo>>>(){});
                this.groupedApiMap.putAll(savedData);
            }
            catch (IOException e) {
                System.err.println("Failed to load API data from file: " + e.getMessage());
            }
        }
    }

    private void saveToFile() {
        try {
            this.objectMapper.writeValue(new File(this.filePath), this.groupedApiMap);
        }
        catch (IOException e) {
            System.err.println("Failed to save API data to file: " + e.getMessage());
        }
    }
}

