/*
 * Decompiled with CFR 0.152.
 */
package api.link.checker.core;

import api.link.checker.annotation.ApiGroup;
import api.link.checker.annotation.TrackApi;
import api.link.checker.core.ApiCheckRepository;
import api.link.checker.core.ApiInfo;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Component
public class ApiScanner
implements ApplicationListener<ContextRefreshedEvent> {
    private final ApiCheckRepository apiCheckRepository;

    public ApiScanner(ApiCheckRepository apiCheckRepository) {
        this.apiCheckRepository = apiCheckRepository;
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        HashMap<String, List<ApiInfo>> scannedApis = new HashMap<String, List<ApiInfo>>();
        Map beans = event.getApplicationContext().getBeansWithAnnotation(ApiGroup.class);
        for (Object bean : beans.values()) {
            Class beanClass = AopUtils.getTargetClass(bean);
            ApiGroup apiGroup = (ApiGroup)AnnotationUtils.findAnnotation((Class)beanClass, ApiGroup.class);
            if (apiGroup == null) continue;
            String groupName = apiGroup.value();
            ArrayList<ApiInfo> apiInfos = new ArrayList<ApiInfo>();
            for (Method method : beanClass.getMethods()) {
                TrackApi trackApi = (TrackApi)AnnotationUtils.findAnnotation((Method)method, TrackApi.class);
                if (trackApi == null) {
                    for (Class<?> iface : beanClass.getInterfaces()) {
                        try {
                            Method interfaceMethod = iface.getMethod(method.getName(), method.getParameterTypes());
                            trackApi = (TrackApi)AnnotationUtils.findAnnotation((Method)interfaceMethod, TrackApi.class);
                            if (trackApi == null) continue;
                            break;
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            // empty catch block
                        }
                    }
                }
                if (trackApi == null) continue;
                String httpMethod = this.findHttpMethod(method);
                String path = this.findPath(beanClass, method);
                apiInfos.add(new ApiInfo(httpMethod, path, trackApi.description(), "", false));
            }
            scannedApis.put(groupName, apiInfos);
        }
        this.updateRepositoryWithScannedApis(scannedApis);
    }

    private void updateRepositoryWithScannedApis(Map<String, List<ApiInfo>> scannedApis) {
        Map<String, List<ApiInfo>> existingApis = this.apiCheckRepository.getAllGroupedApis();
        HashMap<String, List<ApiInfo>> updatedApis = new HashMap<String, List<ApiInfo>>();
        Map<String, ApiInfo> existingApiMap = existingApis.values().stream().flatMap(Collection::stream).collect(Collectors.toMap(api -> api.getHttpMethod() + "_" + api.getPath(), api -> api));
        scannedApis.forEach((groupName, scannedApiList) -> {
            ArrayList<ApiInfo> finalApiList = new ArrayList<ApiInfo>();
            for (ApiInfo scannedApi : scannedApiList) {
                String key = scannedApi.getHttpMethod() + "_" + scannedApi.getPath();
                if (existingApiMap.containsKey(key)) {
                    scannedApi.setChecked(((ApiInfo)existingApiMap.get(key)).isChecked());
                    scannedApi.setNickname(((ApiInfo)existingApiMap.get(key)).isChecked() ? ((ApiInfo)existingApiMap.get(key)).getNickname() : "");
                }
                finalApiList.add(scannedApi);
            }
            updatedApis.put((String)groupName, (List<ApiInfo>)finalApiList);
        });
        this.apiCheckRepository.initializeApis(updatedApis);
    }

    private String findHttpMethod(Method method) {
        if (method.isAnnotationPresent(GetMapping.class)) {
            return "GET";
        }
        if (method.isAnnotationPresent(PostMapping.class)) {
            return "POST";
        }
        if (method.isAnnotationPresent(DeleteMapping.class)) {
            return "DELETE";
        }
        if (method.isAnnotationPresent(PutMapping.class)) {
            return "PUT";
        }
        if (method.isAnnotationPresent(PatchMapping.class)) {
            return "PATCH";
        }
        return "UNKNOWN";
    }

    private String findPath(Class<?> beanClass, Method method) {
        String basePath;
        RequestMapping classMapping = (RequestMapping)AnnotationUtils.findAnnotation(beanClass, RequestMapping.class);
        String string = basePath = classMapping != null && classMapping.value().length > 0 ? classMapping.value()[0] : "";
        if (method.isAnnotationPresent(GetMapping.class)) {
            return this.combinePath(basePath, method.getAnnotation(GetMapping.class).value());
        }
        if (method.isAnnotationPresent(PostMapping.class)) {
            return this.combinePath(basePath, method.getAnnotation(PostMapping.class).value());
        }
        if (method.isAnnotationPresent(DeleteMapping.class)) {
            return this.combinePath(basePath, method.getAnnotation(DeleteMapping.class).value());
        }
        if (method.isAnnotationPresent(PutMapping.class)) {
            return this.combinePath(basePath, method.getAnnotation(PutMapping.class).value());
        }
        if (method.isAnnotationPresent(PatchMapping.class)) {
            return this.combinePath(basePath, method.getAnnotation(PatchMapping.class).value());
        }
        return basePath;
    }

    private String combinePath(String basePath, String[] paths) {
        return basePath + (paths.length > 0 ? paths[0] : "");
    }
}

