/*
 * Decompiled with CFR 0.152.
 */
package api.link.checker.core;

import api.link.checker.core.ApiInfo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class SwaggerService {
    private static final String SWAGGER_URL = "http://localhost:8080/v3/api-docs";

    public Map<String, String> fetchSwaggerLinks(Map<String, List<ApiInfo>> apiInfoMap) {
        ObjectMapper objectMapper = new ObjectMapper();
        HashMap<String, String> swaggerLinks = new HashMap<String, String>();
        try {
            Map swaggerData = (Map)objectMapper.readValue(new URL(SWAGGER_URL), (TypeReference)new TypeReference<Map<String, Object>>(){});
            Map paths = (Map)swaggerData.get("paths");
            for (Map.Entry pathEntry : paths.entrySet()) {
                String path = (String)pathEntry.getKey();
                Map methods = (Map)pathEntry.getValue();
                for (Map.Entry methodEntry : methods.entrySet()) {
                    String httpMethod = ((String)methodEntry.getKey()).toUpperCase();
                    Map methodDetails = (Map)methodEntry.getValue();
                    String operationId = (String)methodDetails.get("operationId");
                    List tags = (List)methodDetails.get("tags");
                    for (Map.Entry<String, List<ApiInfo>> group : apiInfoMap.entrySet()) {
                        for (ApiInfo apiInfo : group.getValue()) {
                            if (!apiInfo.getPath().equals(path) || !apiInfo.getHttpMethod().equalsIgnoreCase(httpMethod)) continue;
                            String tag = tags != null && !tags.isEmpty() ? (String)tags.get(0) : "NoTag";
                            String swaggerPath = tag + "/" + operationId;
                            swaggerLinks.put(apiInfo.getHttpMethod() + "_" + apiInfo.getPath(), swaggerPath);
                        }
                    }
                }
            }
        }
        catch (IOException e) {
            return Collections.emptyMap();
        }
        return swaggerLinks;
    }
}

