/*
 * Decompiled with CFR 0.152.
 */
package io.github.dan2097.jnainchi;

import io.github.dan2097.jnainchi.InchiFlag;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class InchiOptions {
    static final InchiOptions DEFAULT_OPTIONS = new InchiOptionsBuilder().build();
    private static final boolean IS_WINDOWS = System.getProperty("os.name", "").toLowerCase(Locale.ROOT).startsWith("windows");
    private final List<InchiFlag> flags;
    private final long timeoutMilliSecs;

    private InchiOptions(InchiOptionsBuilder builder) {
        this.flags = builder.flags;
        this.timeoutMilliSecs = builder.timeoutMilliSecs;
    }

    public List<InchiFlag> getFlags() {
        return Collections.unmodifiableList(this.flags);
    }

    public int getTimeout() {
        return (int)(this.timeoutMilliSecs / 1000L);
    }

    public long getTimeoutMilliSeconds() {
        return this.timeoutMilliSecs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (InchiFlag inchiFlag : this.flags) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(IS_WINDOWS ? "/" : "-");
            sb.append(inchiFlag.toString());
        }
        if (this.timeoutMilliSecs != 0L) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(IS_WINDOWS ? "/" : "-");
            sb.append("WM");
            sb.append(String.valueOf(this.timeoutMilliSecs));
        }
        return sb.toString();
    }

    public static class InchiOptionsBuilder {
        private final List<InchiFlag> flags = new ArrayList<InchiFlag>();
        private long timeoutMilliSecs = 0L;

        public InchiOptionsBuilder withFlag(InchiFlag ... flags) {
            for (InchiFlag flag : flags) {
                this.flags.add(flag);
            }
            return this;
        }

        public InchiOptionsBuilder withTimeout(int timeoutSecs) {
            if (timeoutSecs < 0) {
                throw new IllegalArgumentException("Timeout should be a time in seconds or 0 for infinite: " + timeoutSecs);
            }
            this.timeoutMilliSecs = (long)timeoutSecs * 1000L;
            return this;
        }

        public InchiOptionsBuilder withTimeoutMilliSeconds(long timeoutMilliSecs) {
            if (timeoutMilliSecs < 0L) {
                throw new IllegalArgumentException("Timeout should be a time in milliseconds or 0 for infinite: " + timeoutMilliSecs);
            }
            this.timeoutMilliSecs = timeoutMilliSecs;
            return this;
        }

        public InchiOptions build() {
            return new InchiOptions(this);
        }
    }
}

