/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcClientProperties;
import grpcstarter.client.Util;
import io.grpc.ManagedChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Cache {
    private static final Logger log = LoggerFactory.getLogger(Cache.class);
    private static final ConcurrentMap<String, List<Class<?>>> serviceToStubClasses = new ConcurrentHashMap();
    private static final Map<GrpcClientProperties.Channel, ManagedChannel> cfgToChannel = Collections.synchronizedMap(new LinkedHashMap());

    private Cache() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static Set<Class<?>> getStubClasses() {
        return serviceToStubClasses.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public static Set<String> getServices() {
        return Collections.unmodifiableSet(serviceToStubClasses.keySet());
    }

    public static void addStubClass(Class<?> stubClass) {
        String service = Util.serviceName(stubClass);
        serviceToStubClasses.computeIfAbsent(service, k -> new ArrayList()).add(stubClass);
    }

    public static ManagedChannel getOrSupplyChannel(GrpcClientProperties.Channel channelConfig, Supplier<ManagedChannel> channelSupplier) {
        return cfgToChannel.computeIfAbsent(channelConfig, k -> (ManagedChannel)channelSupplier.get());
    }

    public static void shutdownChannels() {
        if (cfgToChannel.isEmpty()) {
            return;
        }
        long start = System.currentTimeMillis();
        cfgToChannel.forEach((cfg, channel) -> {
            Long timeout = cfg.getShutdownTimeout();
            Duration duration = timeout != null ? Duration.ofMillis(timeout) : Duration.ofMillis(5000L);
            Util.shutdownChannel(channel, duration);
        });
        if (log.isInfoEnabled()) {
            log.info("{} channels gracefully shutdown in {} ms", (Object)cfgToChannel.size(), (Object)(System.currentTimeMillis() - start));
        }
        cfgToChannel.clear();
    }

    public static void clear() {
        serviceToStubClasses.clear();
        Cache.shutdownChannels();
    }
}

