/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import grpcstarter.client.Cache;
import grpcstarter.client.GrpcChannelCustomizer;
import grpcstarter.client.GrpcClientProperties;
import grpcstarter.client.GrpcClientUtil;
import grpcstarter.client.Util;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.InsecureChannelCredentials;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.TlsChannelCredentials;
import io.grpc.inprocess.InProcessChannelBuilder;
import io.grpc.stub.MetadataUtils;
import java.util.Optional;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

class GrpcChannelCreator {
    private static final Logger log = LoggerFactory.getLogger(GrpcChannelCreator.class);
    private final BeanFactory beanFactory;
    private final GrpcClientProperties.Refresh refreshConfig;
    private final GrpcClientProperties.Channel channelConfig;

    @SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"})
    GrpcChannelCreator(BeanFactory beanFactory, GrpcClientProperties.Channel channelConfig) {
        this.beanFactory = beanFactory;
        this.refreshConfig = GrpcClientUtil.getRefresh((Environment)beanFactory.getBean(Environment.class));
        this.channelConfig = channelConfig;
    }

    public ManagedChannel create() {
        GrpcClientProperties.Channel newestConfig = this.getLatestChannelConfig();
        return Cache.getOrSupplyChannel(newestConfig, () -> this.buildChannel(newestConfig));
    }

    private GrpcClientProperties.Channel getLatestChannelConfig() {
        if (this.refreshConfig.isEnabled()) {
            GrpcClientProperties properties = (GrpcClientProperties)this.beanFactory.getBean(GrpcClientProperties.class);
            GrpcClientProperties.Channel channel = Util.findChannelByName(this.channelConfig.getName(), properties);
            if (channel != null) {
                return channel;
            }
            return this.channelConfig;
        }
        return this.channelConfig;
    }

    static GrpcClientProperties.Channel getMatchedConfig(Class<?> stubClass, GrpcClientProperties grpcClientProperties) {
        return Util.findMatchedConfig(stubClass, grpcClientProperties).orElseGet(grpcClientProperties::defaultChannel);
    }

    private ManagedChannel buildChannel(GrpcClientProperties.Channel channelConfig) {
        ManagedChannelBuilder<?> builder = this.getManagedChannelBuilder(channelConfig);
        Optional.ofNullable(channelConfig.getMaxInboundMessageSize()).map(DataSize::toBytes).map(Long::intValue).ifPresent(arg_0 -> builder.maxInboundMessageSize(arg_0));
        Optional.ofNullable(channelConfig.getMaxInboundMetadataSize()).map(DataSize::toBytes).map(Long::intValue).ifPresent(arg_0 -> builder.maxInboundMetadataSize(arg_0));
        GrpcChannelCreator.setRetry(channelConfig, builder);
        Metadata metadata = new Metadata();
        channelConfig.getMetadata().forEach(m -> {
            Metadata.Key key = Metadata.Key.of((String)m.getKey(), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            m.getValues().forEach(v -> metadata.put(key, v));
        });
        if (!metadata.keys().isEmpty()) {
            ClientInterceptor metadataInterceptor = MetadataUtils.newAttachHeadersInterceptor((Metadata)metadata);
            builder.intercept(new ClientInterceptor[]{metadataInterceptor});
        }
        this.beanFactory.getBeanProvider(ClientInterceptor.class).stream().sorted(AnnotationAwareOrderComparator.INSTANCE.reversed()).forEach(xva$0 -> builder.intercept(new ClientInterceptor[]{xva$0}));
        this.beanFactory.getBeanProvider(GrpcChannelCustomizer.class).orderedStream().forEach(cc -> cc.customize(channelConfig, builder));
        return builder.build();
    }

    private static void setRetry(GrpcClientProperties.Channel channelConfig, ManagedChannelBuilder<?> builder) {
        GrpcClientProperties.Retry retry = channelConfig.getRetry();
        if (retry != null) {
            Optional.ofNullable(retry.getEnabled()).ifPresent(enabled -> {
                if (enabled.booleanValue()) {
                    builder.enableRetry();
                } else {
                    builder.disableRetry();
                }
            });
            Optional.ofNullable(retry.getMaxRetryAttempts()).ifPresent(arg_0 -> builder.maxRetryAttempts(arg_0));
            Optional.ofNullable(retry.getRetryBufferSize()).map(DataSize::toBytes).ifPresent(arg_0 -> builder.retryBufferSize(arg_0));
            Optional.ofNullable(retry.getPerRpcBufferLimit()).map(DataSize::toBytes).ifPresent(arg_0 -> builder.perRpcBufferLimit(arg_0));
        }
    }

    private ManagedChannelBuilder<?> getManagedChannelBuilder(GrpcClientProperties.Channel channelConfig) {
        if (channelConfig.getInProcess() != null) {
            String name = channelConfig.getInProcess().getName();
            if (!StringUtils.hasText((String)name)) {
                throw new IllegalArgumentException("In-process name must not be empty");
            }
            return InProcessChannelBuilder.forName((String)name).directExecutor();
        }
        String sslBundleName = channelConfig.getSslBundle();
        GrpcClientProperties.Tls tls = channelConfig.getTls();
        if (StringUtils.hasText((String)sslBundleName)) {
            return this.createChannelWithSslBundle(channelConfig.getAuthority(), sslBundleName);
        }
        if (tls != null) {
            GrpcChannelCreator.logTlsDeprecationWarning();
            return this.createChannelWithTls(channelConfig.getAuthority(), tls);
        }
        return Grpc.newChannelBuilder((String)channelConfig.getAuthority(), (ChannelCredentials)InsecureChannelCredentials.create());
    }

    private ManagedChannelBuilder<?> createChannelWithSslBundle(String authority, String sslBundleName) {
        TrustManager[] trustManagers;
        SslBundles sslBundles = (SslBundles)this.beanFactory.getBean(SslBundles.class);
        SslBundle sslBundle = sslBundles.getBundle(sslBundleName);
        TlsChannelCredentials.Builder tlsBuilder = TlsChannelCredentials.newBuilder();
        KeyManager[] keyManagers = sslBundle.getManagers().getKeyManagers();
        if (keyManagers != null && keyManagers.length > 0) {
            tlsBuilder.keyManager(keyManagers);
        }
        if ((trustManagers = sslBundle.getManagers().getTrustManagers()) != null && trustManagers.length > 0) {
            tlsBuilder.trustManager(trustManagers);
        }
        return Grpc.newChannelBuilder((String)authority, (ChannelCredentials)tlsBuilder.build());
    }

    private ManagedChannelBuilder<?> createChannelWithTls(String authority, GrpcClientProperties.Tls tls) {
        TlsChannelCredentials.Builder tlsBuilder = TlsChannelCredentials.newBuilder();
        if (tls.getKeyManager() != null) {
            GrpcClientProperties.Tls.KeyManager keyManager = tls.getKeyManager();
            if (StringUtils.hasText((String)keyManager.getPrivateKeyPassword())) {
                tlsBuilder.keyManager(keyManager.getCertChain().getInputStream(), keyManager.getPrivateKey().getInputStream(), keyManager.getPrivateKeyPassword());
            } else {
                tlsBuilder.keyManager(keyManager.getCertChain().getInputStream(), keyManager.getPrivateKey().getInputStream());
            }
        }
        if (tls.getTrustManager() != null) {
            tlsBuilder.trustManager(tls.getTrustManager().getRootCerts().getInputStream());
        }
        return Grpc.newChannelBuilder((String)authority, (ChannelCredentials)tlsBuilder.build());
    }

    private static void logTlsDeprecationWarning() {
        log.warn("Using deprecated 'tls' configuration for gRPC client. Please migrate to 'ssl-bundle' configuration. The 'tls' configuration will be removed in a future version.");
    }
}

