/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.Cache;
import grpcstarter.client.ConditionOnGrpcClientEnabled;
import grpcstarter.client.GrpcClientBeanFactoryInitializationAotProcessor;
import grpcstarter.client.GrpcClientOptionsClientInterceptor;
import grpcstarter.client.GrpcClientProperties;
import grpcstarter.client.GrpcClientRefreshScopeRefreshedEventListener;
import grpcstarter.client.GrpcStubBeanDefinitionRegistry;
import grpcstarter.client.GrpcStubBeanRegistrar;
import grpcstarter.client.ManagedChannels;
import grpcstarter.client.ManagedChannelsImpl;
import grpcstarter.client.ShutdownEventBasedChannelCloser;
import grpcstarter.client.VirtualThreadGrpcChannelCustomizer;
import grpcstarter.server.GrpcServerShutdownEvent;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.autoconfigure.thread.Threading;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionOnGrpcClientEnabled
@EnableConfigurationProperties(value={GrpcClientProperties.class})
public class GrpcClientAutoConfiguration
implements DisposableBean,
ApplicationListener<ApplicationReadyEvent> {
    public void onApplicationEvent(ApplicationReadyEvent event) {
        ConfigurableListableBeanFactory bf = event.getApplicationContext().getBeanFactory();
        if (bf instanceof BeanDefinitionRegistry) {
            BeanDefinitionRegistry bdr = (BeanDefinitionRegistry)bf;
            GrpcStubBeanRegistrar.clearBeanDefinitionCache(bdr);
        }
    }

    @Bean
    static GrpcStubBeanDefinitionRegistry grpcStubBeanDefinitionRegistry() {
        return new GrpcStubBeanDefinitionRegistry();
    }

    @Bean
    @ConditionalOnMissingBean
    public GrpcClientOptionsClientInterceptor grpcClientOptionsClientInterceptor() {
        return new GrpcClientOptionsClientInterceptor();
    }

    @Bean
    @ConditionalOnMissingBean
    public ManagedChannels grpcClientManagedChannels(BeanFactory beanFactory, GrpcClientProperties grpcClientProperties) {
        return new ManagedChannelsImpl(beanFactory, grpcClientProperties);
    }

    @Bean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    @ConditionalOnMissingBean
    public VirtualThreadGrpcChannelCustomizer virtualThreadGrpcChannelCustomizer() {
        return new VirtualThreadGrpcChannelCustomizer();
    }

    public void destroy() {
        Cache.clear();
        GrpcStubBeanDefinitionRegistry.scanInfo.clear();
    }

    @Bean
    static GrpcClientBeanFactoryInitializationAotProcessor grpcClientBeanFactoryInitializationAotProcessor() {
        return new GrpcClientBeanFactoryInitializationAotProcessor();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={GrpcServerShutdownEvent.class})
    static class ChannelCloserConfiguration {
        ChannelCloserConfiguration() {
        }

        @Bean
        public ShutdownEventBasedChannelCloser shutdownEventBasedChannelCloser() {
            return new ShutdownEventBasedChannelCloser();
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={RefreshScopeRefreshedEvent.class})
    static class RefreshConfiguration {
        RefreshConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @ConditionalOnProperty(prefix="grpc.client.refresh", name={"enabled"}, havingValue="true")
        public GrpcClientRefreshScopeRefreshedEventListener grpcClientRefreshScopeRefreshedEventListener() {
            return new GrpcClientRefreshScopeRefreshedEventListener();
        }
    }
}

