/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import io.grpc.stub.AbstractAsyncStub;
import io.grpc.stub.AbstractBlockingStub;
import io.grpc.stub.AbstractFutureStub;
import jakarta.annotation.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;

public interface GrpcClientBeanDefinitionHandler {
    @Nullable
    public BeanDefinition handle(BeanDefinition var1, Class<?> var2);

    public static class Async
    implements GrpcClientBeanDefinitionHandler {
        @Override
        @Nullable
        public BeanDefinition handle(BeanDefinition beanDefinition, Class<?> clazz) {
            return AbstractAsyncStub.class.isAssignableFrom(clazz) ? beanDefinition : null;
        }
    }

    public static class Future
    implements GrpcClientBeanDefinitionHandler {
        @Override
        @Nullable
        public BeanDefinition handle(BeanDefinition beanDefinition, Class<?> clazz) {
            return AbstractFutureStub.class.isAssignableFrom(clazz) ? beanDefinition : null;
        }
    }

    public static class Blocking
    implements GrpcClientBeanDefinitionHandler {
        @Override
        @Nullable
        public BeanDefinition handle(BeanDefinition beanDefinition, Class<?> clazz) {
            return AbstractBlockingStub.class.isAssignableFrom(clazz) ? beanDefinition : null;
        }
    }

    public static class Default
    implements GrpcClientBeanDefinitionHandler {
        @Override
        @Nullable
        public BeanDefinition handle(BeanDefinition beanDefinition, Class<?> clazz) {
            return beanDefinition;
        }
    }
}

