/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcClientUtil;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractStub;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.Modifier;
import org.springframework.aot.generate.MethodReference;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.aot.BeanRegistrationExcludeFilter;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RegisteredBean;
import org.springframework.core.env.Environment;
import org.springframework.javapoet.MethodSpec;

class GrpcClientBeanFactoryInitializationAotProcessor
implements BeanRegistrationExcludeFilter,
BeanFactoryInitializationAotProcessor {
    GrpcClientBeanFactoryInitializationAotProcessor() {
    }

    public boolean isExcludedFromAotProcessing(RegisteredBean registeredBean) {
        return GrpcClientBeanFactoryInitializationAotProcessor.isGrpcClient(registeredBean) || GrpcClientBeanFactoryInitializationAotProcessor.isManagedChannel(registeredBean);
    }

    @Nullable
    public BeanFactoryInitializationAotContribution processAheadOfTime(@Nonnull ConfigurableListableBeanFactory beanFactory) {
        return (generationContext, beanFactoryInitializationCode) -> {
            Map<String, BeanDefinition> clientBeanDefinitions = GrpcClientBeanFactoryInitializationAotProcessor.listClientDefinitions(beanFactory);
            Map<String, BeanDefinition> channelBeanDefinitions = GrpcClientBeanFactoryInitializationAotProcessor.listChannelDefinitions(beanFactory);
            if (!channelBeanDefinitions.isEmpty()) {
                MethodReference channelMethodReference = beanFactoryInitializationCode.getMethods().add("registerGrpcChannelBeanDefinitions", GrpcClientBeanFactoryInitializationAotProcessor::buildChannelMethod).toMethodReference();
                beanFactoryInitializationCode.addInitializer(channelMethodReference);
            }
            if (!clientBeanDefinitions.isEmpty()) {
                MethodReference clientMethodReference = beanFactoryInitializationCode.getMethods().add("registerGrpcClientBeanDefinitions", method -> GrpcClientBeanFactoryInitializationAotProcessor.buildClientMethod(method, clientBeanDefinitions)).toMethodReference();
                beanFactoryInitializationCode.addInitializer(clientMethodReference);
            }
            ReflectionHints reflection = generationContext.getRuntimeHints().reflection();
            for (Map.Entry<String, BeanDefinition> entry : clientBeanDefinitions.entrySet()) {
                Class<?> grpcClass;
                BeanDefinition beanDefinition = entry.getValue();
                Class clientClass = beanDefinition.getResolvableType().resolve();
                if (clientClass == null || (grpcClass = clientClass.getEnclosingClass()) == null) continue;
                reflection.registerType(grpcClass, builder -> {
                    builder.withMethod("newBlockingStub", List.of(TypeReference.of(Channel.class)), ExecutableMode.INVOKE);
                    builder.withMethod("newStub", List.of(TypeReference.of(Channel.class)), ExecutableMode.INVOKE);
                    builder.withMethod("newFutureStub", List.of(TypeReference.of(Channel.class)), ExecutableMode.INVOKE);
                    if (Arrays.stream(grpcClass.getMethods()).anyMatch(e -> e.getName().equals("newBlockingV2Stub"))) {
                        builder.withMethod("newBlockingV2Stub", List.of(TypeReference.of(Channel.class)), ExecutableMode.INVOKE);
                    }
                    builder.withField("SERVICE_NAME");
                });
            }
        };
    }

    private static void buildClientMethod(MethodSpec.Builder method, Map<String, BeanDefinition> definitions) {
        method.addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addParameter(DefaultListableBeanFactory.class, "beanFactory", new Modifier[0]);
        definitions.forEach((beanName, beanDefinition) -> {
            Class clientClass = beanDefinition.getResolvableType().resolve();
            method.addStatement("$T.registerGrpcClientBean(beanFactory, $T.class)", new Object[]{GrpcClientUtil.class, clientClass});
        });
    }

    private static void buildChannelMethod(MethodSpec.Builder method) {
        method.addModifiers(new Modifier[]{Modifier.PUBLIC});
        method.addParameter(DefaultListableBeanFactory.class, "beanFactory", new Modifier[0]);
        method.addParameter(Environment.class, "environment", new Modifier[0]);
        method.addStatement("$T.registerGrpcChannelBeans(beanFactory, environment)", new Object[]{GrpcClientUtil.class});
    }

    private static Map<String, BeanDefinition> listClientDefinitions(ConfigurableListableBeanFactory beanFactory) {
        HashMap<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
            Class clz = beanDefinition.getResolvableType().resolve();
            if (clz == null || !AbstractStub.class.isAssignableFrom(clz)) continue;
            beanDefinitions.put(name, beanDefinition);
        }
        return beanDefinitions;
    }

    private static Map<String, BeanDefinition> listChannelDefinitions(ConfigurableListableBeanFactory beanFactory) {
        HashMap<String, BeanDefinition> beanDefinitions = new HashMap<String, BeanDefinition>();
        for (String name : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition beanDefinition;
            Class clz;
            if (!name.startsWith("grpc-channel-") || (clz = (beanDefinition = beanFactory.getBeanDefinition(name)).getResolvableType().resolve()) == null || !ManagedChannel.class.isAssignableFrom(clz)) continue;
            beanDefinitions.put(name, beanDefinition);
        }
        return beanDefinitions;
    }

    private static boolean isManagedChannel(RegisteredBean registeredBean) {
        return ManagedChannel.class.isAssignableFrom(registeredBean.getBeanClass()) && GrpcClientBeanFactoryInitializationAotProcessor.isCreatedByFramework(registeredBean);
    }

    private static boolean isGrpcClient(RegisteredBean registeredBean) {
        return AbstractStub.class.isAssignableFrom(registeredBean.getBeanClass()) && GrpcClientBeanFactoryInitializationAotProcessor.isCreatedByFramework(registeredBean);
    }

    private static boolean isCreatedByFramework(RegisteredBean registeredBean) {
        return registeredBean.getMergedBeanDefinition().hasAttribute("isCreatedByFramework");
    }
}

