/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.Cache;
import grpcstarter.client.GrpcChannelCreator;
import grpcstarter.client.GrpcClientOptions;
import grpcstarter.client.GrpcClientProperties;
import grpcstarter.client.exception.MissingChannelConfigurationException;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractStub;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.unit.DataSize;

class GrpcClientCreator {
    static final String NEW_BLOCKING_STUB_METHOD = "newBlockingStub";
    static final String NEW_BLOCKING_V2_STUB_METHOD = "newBlockingV2Stub";
    static final String NEW_FUTURE_STUB_METHOD = "newFutureStub";
    static final String NEW_STUB_METHOD = "newStub";
    private static final String BLOCKING_STUB = "BlockingStub";
    private static final String BLOCKING_V2_STUB = "BlockingV2Stub";
    private static final String FUTURE_STUB = "FutureStub";
    private final BeanFactory beanFactory;
    private final Class<?> stubClass;

    GrpcClientCreator(BeanFactory beanFactory, Class<?> stubClass) {
        this.beanFactory = beanFactory;
        this.stubClass = stubClass;
    }

    public <T> T create() {
        Method stubMethod = ReflectionUtils.findMethod(this.stubClass.getEnclosingClass(), (String)GrpcClientCreator.getStubMethodName(this.stubClass), (Class[])new Class[]{Channel.class});
        Assert.notNull((Object)stubMethod, (String)"stubMethod must not be null");
        GrpcClientProperties properties = (GrpcClientProperties)this.beanFactory.getBean(GrpcClientProperties.class);
        String channelBeanName = "grpc-channel-" + this.getMatchedConfig(properties).getName();
        if (!this.beanFactory.containsBean(channelBeanName)) {
            throw new MissingChannelConfigurationException(this.stubClass);
        }
        ManagedChannel channel = (ManagedChannel)this.beanFactory.getBean(channelBeanName, ManagedChannel.class);
        Object stub = ReflectionUtils.invokeMethod((Method)stubMethod, null, (Object[])new Object[]{channel});
        Assert.isTrue((stub != null ? 1 : 0) != 0, (String)"stub must not be null");
        stub = GrpcClientCreator.setOptions(stub, properties);
        Cache.addStubClass(this.stubClass);
        return (T)stub;
    }

    private GrpcClientProperties.Channel getMatchedConfig(GrpcClientProperties properties) {
        return GrpcChannelCreator.getMatchedConfig(this.stubClass, properties);
    }

    private static <T> T setOptions(T stub, GrpcClientProperties properties) {
        GrpcClientProperties.Channel cfg = GrpcChannelCreator.getMatchedConfig(AopProxyUtils.ultimateTargetClass(stub), properties);
        GrpcClientOptions opt = new GrpcClientOptions();
        GrpcClientCreator.setOptionValues(opt, cfg);
        return (T)((AbstractStub)stub).withOption(GrpcClientOptions.KEY, (Object)opt);
    }

    static void setOptionValues(GrpcClientOptions opt, GrpcClientProperties.Channel cfg) {
        Optional.ofNullable(cfg.getDeadline()).ifPresent(opt::setDeadline);
        Optional.ofNullable(cfg.getMaxOutboundMessageSize()).map(DataSize::toBytes).map(Long::intValue).ifPresent(opt::setMaxOutboundMessageSize);
        Optional.ofNullable(cfg.getCompression()).ifPresent(opt::setCompression);
    }

    private static String getStubMethodName(Class<?> stubClass) {
        String className = stubClass.getName();
        if (className.endsWith(BLOCKING_STUB)) {
            return NEW_BLOCKING_STUB_METHOD;
        }
        if (className.endsWith(BLOCKING_V2_STUB)) {
            return NEW_BLOCKING_V2_STUB_METHOD;
        }
        if (className.endsWith(FUTURE_STUB)) {
            return NEW_FUTURE_STUB_METHOD;
        }
        return NEW_STUB_METHOD;
    }
}

