/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcClientOptions;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.Deadline;
import io.grpc.MethodDescriptor;
import java.util.concurrent.TimeUnit;

public class GrpcClientOptionsClientInterceptor
implements ClientInterceptor {
    public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
        String compressor;
        Integer maxOutboundMessageSize;
        GrpcClientOptions opt = (GrpcClientOptions)callOptions.getOption(GrpcClientOptions.KEY);
        if (opt == null) {
            return next.newCall(method, callOptions);
        }
        Deadline deadline = callOptions.getDeadline();
        if (deadline == null && opt.getDeadline() != null) {
            callOptions = callOptions.withDeadlineAfter(opt.getDeadline().longValue(), TimeUnit.MILLISECONDS);
        }
        if ((maxOutboundMessageSize = callOptions.getMaxOutboundMessageSize()) == null && opt.getMaxOutboundMessageSize() != null) {
            callOptions = callOptions.withMaxOutboundMessageSize(opt.getMaxOutboundMessageSize().intValue());
        }
        if ((compressor = callOptions.getCompressor()) == null && opt.getCompression() != null) {
            callOptions = callOptions.withCompression(opt.getCompression());
        }
        return next.newCall(method, callOptions);
    }
}

