/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcClientBeanDefinitionHandler;
import io.grpc.stub.AbstractStub;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.springframework.util.unit.DataSize;

@ConfigurationProperties(prefix="grpc.client")
public class GrpcClientProperties
implements InitializingBean {
    public static final String PREFIX = "grpc.client";
    private boolean enabled = true;
    private String authority;
    private List<String> basePackages = new ArrayList<String>();
    private Class<? extends GrpcClientBeanDefinitionHandler> beanDefinitionHandler;
    private List<Class<? extends AbstractStub>> clients = new ArrayList<Class<? extends AbstractStub>>();
    private DataSize maxInboundMessageSize;
    private DataSize maxOutboundMessageSize;
    private DataSize maxInboundMetadataSize;
    private List<Metadata> metadata = new ArrayList<Metadata>();
    private InProcess inProcess;
    private Long shutdownTimeout = 5000L;
    @Deprecated(since="3.5.3", forRemoval=true)
    private Tls tls;
    private String sslBundle;
    private Retry retry;
    private Long deadline;
    private String compression;
    private List<Channel> channels = new ArrayList<Channel>();
    private Refresh refresh = new Refresh();

    public void afterPropertiesSet() {
        this.merge();
        this.setChannelNames();
    }

    void merge() {
        PropertyMapper mapper = PropertyMapper.get().alwaysApplyingWhenNonNull();
        for (Channel stub : this.channels) {
            mapper.from((Object)this.authority).when(e -> Objects.isNull(stub.getAuthority())).to(stub::setAuthority);
            mapper.from((Object)this.maxInboundMessageSize).when(e -> Objects.isNull(stub.getMaxInboundMessageSize())).to(stub::setMaxInboundMessageSize);
            mapper.from((Object)this.maxOutboundMessageSize).when(e -> Objects.isNull(stub.getMaxOutboundMessageSize())).to(stub::setMaxOutboundMessageSize);
            mapper.from((Object)this.maxInboundMetadataSize).when(e -> Objects.isNull(stub.getMaxInboundMetadataSize())).to(stub::setMaxInboundMetadataSize);
            mapper.from((Object)this.shutdownTimeout).when(e -> Objects.isNull(stub.getShutdownTimeout())).to(stub::setShutdownTimeout);
            mapper.from((Object)this.inProcess).when(e -> Objects.isNull(stub.getInProcess())).to(stub::setInProcess);
            mapper.from((Object)this.tls).when(e -> Objects.isNull(stub.getTls())).to(stub::setTls);
            mapper.from((Object)this.sslBundle).when(e -> Objects.isNull(stub.getSslBundle())).to(stub::setSslBundle);
            mapper.from((Object)this.retry).when(e -> Objects.isNull(stub.getRetry())).to(stub::setRetry);
            mapper.from((Object)this.deadline).when(e -> Objects.isNull(stub.getDeadline())).to(stub::setDeadline);
            mapper.from((Object)this.compression).when(e -> Objects.isNull(stub.getCompression())).to(stub::setCompression);
            LinkedHashMap total = this.metadata.stream().collect(Collectors.toMap(Metadata::getKey, Metadata::getValues, (oldV, newV) -> oldV, LinkedHashMap::new));
            for (Metadata m : stub.getMetadata()) {
                total.put(m.getKey(), m.getValues());
            }
            List<Metadata> merged = total.entrySet().stream().map(e -> new Metadata((String)e.getKey(), (List)e.getValue())).collect(Collectors.toList());
            stub.setMetadata(merged);
        }
    }

    void setChannelNames() {
        List<Channel> unnamedChannels = this.channels.stream().filter(ch -> !StringUtils.hasText((String)ch.getName())).toList();
        for (int i = 0; i < unnamedChannels.size(); ++i) {
            unnamedChannels.get(i).setName("unnamed-" + i);
        }
        HashSet<String> names = new HashSet<String>();
        for (Channel channel : this.channels) {
            String name = channel.getName();
            if (names.contains(name)) {
                throw new IllegalArgumentException("Duplicate channel name: " + name);
            }
            names.add(name);
        }
    }

    Channel defaultChannel() {
        return new Channel("__default__", this.authority, this.maxInboundMessageSize, this.maxOutboundMessageSize, this.maxInboundMetadataSize, this.shutdownTimeout, this.metadata, this.inProcess, this.tls, this.sslBundle, this.retry, this.deadline, this.compression, null, null, null);
    }

    @Generated
    public GrpcClientProperties() {
    }

    @Generated
    public boolean isEnabled() {
        return this.enabled;
    }

    @Generated
    public String getAuthority() {
        return this.authority;
    }

    @Generated
    public List<String> getBasePackages() {
        return this.basePackages;
    }

    @Generated
    public Class<? extends GrpcClientBeanDefinitionHandler> getBeanDefinitionHandler() {
        return this.beanDefinitionHandler;
    }

    @Generated
    public List<Class<? extends AbstractStub>> getClients() {
        return this.clients;
    }

    @Generated
    public DataSize getMaxInboundMessageSize() {
        return this.maxInboundMessageSize;
    }

    @Generated
    public DataSize getMaxOutboundMessageSize() {
        return this.maxOutboundMessageSize;
    }

    @Generated
    public DataSize getMaxInboundMetadataSize() {
        return this.maxInboundMetadataSize;
    }

    @Generated
    public List<Metadata> getMetadata() {
        return this.metadata;
    }

    @Generated
    public InProcess getInProcess() {
        return this.inProcess;
    }

    @Generated
    public Long getShutdownTimeout() {
        return this.shutdownTimeout;
    }

    @Deprecated
    @Generated
    public Tls getTls() {
        return this.tls;
    }

    @Generated
    public String getSslBundle() {
        return this.sslBundle;
    }

    @Generated
    public Retry getRetry() {
        return this.retry;
    }

    @Generated
    public Long getDeadline() {
        return this.deadline;
    }

    @Generated
    public String getCompression() {
        return this.compression;
    }

    @Generated
    public List<Channel> getChannels() {
        return this.channels;
    }

    @Generated
    public Refresh getRefresh() {
        return this.refresh;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public void setAuthority(String authority) {
        this.authority = authority;
    }

    @Generated
    public void setBasePackages(List<String> basePackages) {
        this.basePackages = basePackages;
    }

    @Generated
    public void setBeanDefinitionHandler(Class<? extends GrpcClientBeanDefinitionHandler> beanDefinitionHandler) {
        this.beanDefinitionHandler = beanDefinitionHandler;
    }

    @Generated
    public void setClients(List<Class<? extends AbstractStub>> clients) {
        this.clients = clients;
    }

    @Generated
    public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
        this.maxInboundMessageSize = maxInboundMessageSize;
    }

    @Generated
    public void setMaxOutboundMessageSize(DataSize maxOutboundMessageSize) {
        this.maxOutboundMessageSize = maxOutboundMessageSize;
    }

    @Generated
    public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
        this.maxInboundMetadataSize = maxInboundMetadataSize;
    }

    @Generated
    public void setMetadata(List<Metadata> metadata) {
        this.metadata = metadata;
    }

    @Generated
    public void setInProcess(InProcess inProcess) {
        this.inProcess = inProcess;
    }

    @Generated
    public void setShutdownTimeout(Long shutdownTimeout) {
        this.shutdownTimeout = shutdownTimeout;
    }

    @Deprecated
    @Generated
    public void setTls(Tls tls) {
        this.tls = tls;
    }

    @Generated
    public void setSslBundle(String sslBundle) {
        this.sslBundle = sslBundle;
    }

    @Generated
    public void setRetry(Retry retry) {
        this.retry = retry;
    }

    @Generated
    public void setDeadline(Long deadline) {
        this.deadline = deadline;
    }

    @Generated
    public void setCompression(String compression) {
        this.compression = compression;
    }

    @Generated
    public void setChannels(List<Channel> channels) {
        this.channels = channels;
    }

    @Generated
    public void setRefresh(Refresh refresh) {
        this.refresh = refresh;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GrpcClientProperties)) {
            return false;
        }
        GrpcClientProperties other = (GrpcClientProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        Long this$shutdownTimeout = this.getShutdownTimeout();
        Long other$shutdownTimeout = other.getShutdownTimeout();
        if (this$shutdownTimeout == null ? other$shutdownTimeout != null : !((Object)this$shutdownTimeout).equals(other$shutdownTimeout)) {
            return false;
        }
        Long this$deadline = this.getDeadline();
        Long other$deadline = other.getDeadline();
        if (this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline)) {
            return false;
        }
        String this$authority = this.getAuthority();
        String other$authority = other.getAuthority();
        if (this$authority == null ? other$authority != null : !this$authority.equals(other$authority)) {
            return false;
        }
        List<String> this$basePackages = this.getBasePackages();
        List<String> other$basePackages = other.getBasePackages();
        if (this$basePackages == null ? other$basePackages != null : !((Object)this$basePackages).equals(other$basePackages)) {
            return false;
        }
        Class<? extends GrpcClientBeanDefinitionHandler> this$beanDefinitionHandler = this.getBeanDefinitionHandler();
        Class<? extends GrpcClientBeanDefinitionHandler> other$beanDefinitionHandler = other.getBeanDefinitionHandler();
        if (this$beanDefinitionHandler == null ? other$beanDefinitionHandler != null : !this$beanDefinitionHandler.equals(other$beanDefinitionHandler)) {
            return false;
        }
        List<Class<? extends AbstractStub>> this$clients = this.getClients();
        List<Class<? extends AbstractStub>> other$clients = other.getClients();
        if (this$clients == null ? other$clients != null : !((Object)this$clients).equals(other$clients)) {
            return false;
        }
        DataSize this$maxInboundMessageSize = this.getMaxInboundMessageSize();
        DataSize other$maxInboundMessageSize = other.getMaxInboundMessageSize();
        if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !this$maxInboundMessageSize.equals(other$maxInboundMessageSize)) {
            return false;
        }
        DataSize this$maxOutboundMessageSize = this.getMaxOutboundMessageSize();
        DataSize other$maxOutboundMessageSize = other.getMaxOutboundMessageSize();
        if (this$maxOutboundMessageSize == null ? other$maxOutboundMessageSize != null : !this$maxOutboundMessageSize.equals(other$maxOutboundMessageSize)) {
            return false;
        }
        DataSize this$maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        DataSize other$maxInboundMetadataSize = other.getMaxInboundMetadataSize();
        if (this$maxInboundMetadataSize == null ? other$maxInboundMetadataSize != null : !this$maxInboundMetadataSize.equals(other$maxInboundMetadataSize)) {
            return false;
        }
        List<Metadata> this$metadata = this.getMetadata();
        List<Metadata> other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
            return false;
        }
        InProcess this$inProcess = this.getInProcess();
        InProcess other$inProcess = other.getInProcess();
        if (this$inProcess == null ? other$inProcess != null : !((Object)this$inProcess).equals(other$inProcess)) {
            return false;
        }
        Tls this$tls = this.getTls();
        Tls other$tls = other.getTls();
        if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
            return false;
        }
        String this$sslBundle = this.getSslBundle();
        String other$sslBundle = other.getSslBundle();
        if (this$sslBundle == null ? other$sslBundle != null : !this$sslBundle.equals(other$sslBundle)) {
            return false;
        }
        Retry this$retry = this.getRetry();
        Retry other$retry = other.getRetry();
        if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
            return false;
        }
        String this$compression = this.getCompression();
        String other$compression = other.getCompression();
        if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
            return false;
        }
        List<Channel> this$channels = this.getChannels();
        List<Channel> other$channels = other.getChannels();
        if (this$channels == null ? other$channels != null : !((Object)this$channels).equals(other$channels)) {
            return false;
        }
        Refresh this$refresh = this.getRefresh();
        Refresh other$refresh = other.getRefresh();
        return !(this$refresh == null ? other$refresh != null : !((Object)this$refresh).equals(other$refresh));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GrpcClientProperties;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        Long $shutdownTimeout = this.getShutdownTimeout();
        result = result * 59 + ($shutdownTimeout == null ? 43 : ((Object)$shutdownTimeout).hashCode());
        Long $deadline = this.getDeadline();
        result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
        String $authority = this.getAuthority();
        result = result * 59 + ($authority == null ? 43 : $authority.hashCode());
        List<String> $basePackages = this.getBasePackages();
        result = result * 59 + ($basePackages == null ? 43 : ((Object)$basePackages).hashCode());
        Class<? extends GrpcClientBeanDefinitionHandler> $beanDefinitionHandler = this.getBeanDefinitionHandler();
        result = result * 59 + ($beanDefinitionHandler == null ? 43 : $beanDefinitionHandler.hashCode());
        List<Class<? extends AbstractStub>> $clients = this.getClients();
        result = result * 59 + ($clients == null ? 43 : ((Object)$clients).hashCode());
        DataSize $maxInboundMessageSize = this.getMaxInboundMessageSize();
        result = result * 59 + ($maxInboundMessageSize == null ? 43 : $maxInboundMessageSize.hashCode());
        DataSize $maxOutboundMessageSize = this.getMaxOutboundMessageSize();
        result = result * 59 + ($maxOutboundMessageSize == null ? 43 : $maxOutboundMessageSize.hashCode());
        DataSize $maxInboundMetadataSize = this.getMaxInboundMetadataSize();
        result = result * 59 + ($maxInboundMetadataSize == null ? 43 : $maxInboundMetadataSize.hashCode());
        List<Metadata> $metadata = this.getMetadata();
        result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
        InProcess $inProcess = this.getInProcess();
        result = result * 59 + ($inProcess == null ? 43 : ((Object)$inProcess).hashCode());
        Tls $tls = this.getTls();
        result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
        String $sslBundle = this.getSslBundle();
        result = result * 59 + ($sslBundle == null ? 43 : $sslBundle.hashCode());
        Retry $retry = this.getRetry();
        result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
        String $compression = this.getCompression();
        result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
        List<Channel> $channels = this.getChannels();
        result = result * 59 + ($channels == null ? 43 : ((Object)$channels).hashCode());
        Refresh $refresh = this.getRefresh();
        result = result * 59 + ($refresh == null ? 43 : ((Object)$refresh).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GrpcClientProperties(enabled=" + this.isEnabled() + ", authority=" + this.getAuthority() + ", basePackages=" + String.valueOf(this.getBasePackages()) + ", beanDefinitionHandler=" + String.valueOf(this.getBeanDefinitionHandler()) + ", clients=" + String.valueOf(this.getClients()) + ", maxInboundMessageSize=" + String.valueOf(this.getMaxInboundMessageSize()) + ", maxOutboundMessageSize=" + String.valueOf(this.getMaxOutboundMessageSize()) + ", maxInboundMetadataSize=" + String.valueOf(this.getMaxInboundMetadataSize()) + ", metadata=" + String.valueOf(this.getMetadata()) + ", inProcess=" + String.valueOf(this.getInProcess()) + ", shutdownTimeout=" + this.getShutdownTimeout() + ", tls=" + String.valueOf(this.getTls()) + ", sslBundle=" + this.getSslBundle() + ", retry=" + String.valueOf(this.getRetry()) + ", deadline=" + this.getDeadline() + ", compression=" + this.getCompression() + ", channels=" + String.valueOf(this.getChannels()) + ", refresh=" + String.valueOf(this.getRefresh()) + ")";
    }

    public static class Channel {
        private String name;
        private String authority;
        private DataSize maxInboundMessageSize;
        private DataSize maxOutboundMessageSize;
        private DataSize maxInboundMetadataSize;
        private Long shutdownTimeout;
        private List<Metadata> metadata = new ArrayList<Metadata>();
        private InProcess inProcess;
        @Deprecated(since="3.5.3", forRemoval=true)
        private Tls tls;
        private String sslBundle;
        private Retry retry;
        private Long deadline;
        private String compression;
        private List<Class<? extends AbstractStub>> classes = new ArrayList<Class<? extends AbstractStub>>();
        private List<String> stubs = new ArrayList<String>();
        private List<String> services = new ArrayList<String>();

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public String getAuthority() {
            return this.authority;
        }

        @Generated
        public DataSize getMaxInboundMessageSize() {
            return this.maxInboundMessageSize;
        }

        @Generated
        public DataSize getMaxOutboundMessageSize() {
            return this.maxOutboundMessageSize;
        }

        @Generated
        public DataSize getMaxInboundMetadataSize() {
            return this.maxInboundMetadataSize;
        }

        @Generated
        public Long getShutdownTimeout() {
            return this.shutdownTimeout;
        }

        @Generated
        public List<Metadata> getMetadata() {
            return this.metadata;
        }

        @Generated
        public InProcess getInProcess() {
            return this.inProcess;
        }

        @Deprecated
        @Generated
        public Tls getTls() {
            return this.tls;
        }

        @Generated
        public String getSslBundle() {
            return this.sslBundle;
        }

        @Generated
        public Retry getRetry() {
            return this.retry;
        }

        @Generated
        public Long getDeadline() {
            return this.deadline;
        }

        @Generated
        public String getCompression() {
            return this.compression;
        }

        @Generated
        public List<Class<? extends AbstractStub>> getClasses() {
            return this.classes;
        }

        @Generated
        public List<String> getStubs() {
            return this.stubs;
        }

        @Generated
        public List<String> getServices() {
            return this.services;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setAuthority(String authority) {
            this.authority = authority;
        }

        @Generated
        public void setMaxInboundMessageSize(DataSize maxInboundMessageSize) {
            this.maxInboundMessageSize = maxInboundMessageSize;
        }

        @Generated
        public void setMaxOutboundMessageSize(DataSize maxOutboundMessageSize) {
            this.maxOutboundMessageSize = maxOutboundMessageSize;
        }

        @Generated
        public void setMaxInboundMetadataSize(DataSize maxInboundMetadataSize) {
            this.maxInboundMetadataSize = maxInboundMetadataSize;
        }

        @Generated
        public void setShutdownTimeout(Long shutdownTimeout) {
            this.shutdownTimeout = shutdownTimeout;
        }

        @Generated
        public void setMetadata(List<Metadata> metadata) {
            this.metadata = metadata;
        }

        @Generated
        public void setInProcess(InProcess inProcess) {
            this.inProcess = inProcess;
        }

        @Deprecated
        @Generated
        public void setTls(Tls tls) {
            this.tls = tls;
        }

        @Generated
        public void setSslBundle(String sslBundle) {
            this.sslBundle = sslBundle;
        }

        @Generated
        public void setRetry(Retry retry) {
            this.retry = retry;
        }

        @Generated
        public void setDeadline(Long deadline) {
            this.deadline = deadline;
        }

        @Generated
        public void setCompression(String compression) {
            this.compression = compression;
        }

        @Generated
        public void setClasses(List<Class<? extends AbstractStub>> classes) {
            this.classes = classes;
        }

        @Generated
        public void setStubs(List<String> stubs) {
            this.stubs = stubs;
        }

        @Generated
        public void setServices(List<String> services) {
            this.services = services;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Channel)) {
                return false;
            }
            Channel other = (Channel)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$shutdownTimeout = this.getShutdownTimeout();
            Long other$shutdownTimeout = other.getShutdownTimeout();
            if (this$shutdownTimeout == null ? other$shutdownTimeout != null : !((Object)this$shutdownTimeout).equals(other$shutdownTimeout)) {
                return false;
            }
            Long this$deadline = this.getDeadline();
            Long other$deadline = other.getDeadline();
            if (this$deadline == null ? other$deadline != null : !((Object)this$deadline).equals(other$deadline)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$authority = this.getAuthority();
            String other$authority = other.getAuthority();
            if (this$authority == null ? other$authority != null : !this$authority.equals(other$authority)) {
                return false;
            }
            DataSize this$maxInboundMessageSize = this.getMaxInboundMessageSize();
            DataSize other$maxInboundMessageSize = other.getMaxInboundMessageSize();
            if (this$maxInboundMessageSize == null ? other$maxInboundMessageSize != null : !this$maxInboundMessageSize.equals(other$maxInboundMessageSize)) {
                return false;
            }
            DataSize this$maxOutboundMessageSize = this.getMaxOutboundMessageSize();
            DataSize other$maxOutboundMessageSize = other.getMaxOutboundMessageSize();
            if (this$maxOutboundMessageSize == null ? other$maxOutboundMessageSize != null : !this$maxOutboundMessageSize.equals(other$maxOutboundMessageSize)) {
                return false;
            }
            DataSize this$maxInboundMetadataSize = this.getMaxInboundMetadataSize();
            DataSize other$maxInboundMetadataSize = other.getMaxInboundMetadataSize();
            if (this$maxInboundMetadataSize == null ? other$maxInboundMetadataSize != null : !this$maxInboundMetadataSize.equals(other$maxInboundMetadataSize)) {
                return false;
            }
            List<Metadata> this$metadata = this.getMetadata();
            List<Metadata> other$metadata = other.getMetadata();
            if (this$metadata == null ? other$metadata != null : !((Object)this$metadata).equals(other$metadata)) {
                return false;
            }
            InProcess this$inProcess = this.getInProcess();
            InProcess other$inProcess = other.getInProcess();
            if (this$inProcess == null ? other$inProcess != null : !((Object)this$inProcess).equals(other$inProcess)) {
                return false;
            }
            Tls this$tls = this.getTls();
            Tls other$tls = other.getTls();
            if (this$tls == null ? other$tls != null : !((Object)this$tls).equals(other$tls)) {
                return false;
            }
            String this$sslBundle = this.getSslBundle();
            String other$sslBundle = other.getSslBundle();
            if (this$sslBundle == null ? other$sslBundle != null : !this$sslBundle.equals(other$sslBundle)) {
                return false;
            }
            Retry this$retry = this.getRetry();
            Retry other$retry = other.getRetry();
            if (this$retry == null ? other$retry != null : !((Object)this$retry).equals(other$retry)) {
                return false;
            }
            String this$compression = this.getCompression();
            String other$compression = other.getCompression();
            if (this$compression == null ? other$compression != null : !this$compression.equals(other$compression)) {
                return false;
            }
            List<Class<? extends AbstractStub>> this$classes = this.getClasses();
            List<Class<? extends AbstractStub>> other$classes = other.getClasses();
            if (this$classes == null ? other$classes != null : !((Object)this$classes).equals(other$classes)) {
                return false;
            }
            List<String> this$stubs = this.getStubs();
            List<String> other$stubs = other.getStubs();
            if (this$stubs == null ? other$stubs != null : !((Object)this$stubs).equals(other$stubs)) {
                return false;
            }
            List<String> this$services = this.getServices();
            List<String> other$services = other.getServices();
            return !(this$services == null ? other$services != null : !((Object)this$services).equals(other$services));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Channel;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $shutdownTimeout = this.getShutdownTimeout();
            result = result * 59 + ($shutdownTimeout == null ? 43 : ((Object)$shutdownTimeout).hashCode());
            Long $deadline = this.getDeadline();
            result = result * 59 + ($deadline == null ? 43 : ((Object)$deadline).hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $authority = this.getAuthority();
            result = result * 59 + ($authority == null ? 43 : $authority.hashCode());
            DataSize $maxInboundMessageSize = this.getMaxInboundMessageSize();
            result = result * 59 + ($maxInboundMessageSize == null ? 43 : $maxInboundMessageSize.hashCode());
            DataSize $maxOutboundMessageSize = this.getMaxOutboundMessageSize();
            result = result * 59 + ($maxOutboundMessageSize == null ? 43 : $maxOutboundMessageSize.hashCode());
            DataSize $maxInboundMetadataSize = this.getMaxInboundMetadataSize();
            result = result * 59 + ($maxInboundMetadataSize == null ? 43 : $maxInboundMetadataSize.hashCode());
            List<Metadata> $metadata = this.getMetadata();
            result = result * 59 + ($metadata == null ? 43 : ((Object)$metadata).hashCode());
            InProcess $inProcess = this.getInProcess();
            result = result * 59 + ($inProcess == null ? 43 : ((Object)$inProcess).hashCode());
            Tls $tls = this.getTls();
            result = result * 59 + ($tls == null ? 43 : ((Object)$tls).hashCode());
            String $sslBundle = this.getSslBundle();
            result = result * 59 + ($sslBundle == null ? 43 : $sslBundle.hashCode());
            Retry $retry = this.getRetry();
            result = result * 59 + ($retry == null ? 43 : ((Object)$retry).hashCode());
            String $compression = this.getCompression();
            result = result * 59 + ($compression == null ? 43 : $compression.hashCode());
            List<Class<? extends AbstractStub>> $classes = this.getClasses();
            result = result * 59 + ($classes == null ? 43 : ((Object)$classes).hashCode());
            List<String> $stubs = this.getStubs();
            result = result * 59 + ($stubs == null ? 43 : ((Object)$stubs).hashCode());
            List<String> $services = this.getServices();
            result = result * 59 + ($services == null ? 43 : ((Object)$services).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcClientProperties.Channel(name=" + this.getName() + ", authority=" + this.getAuthority() + ", maxInboundMessageSize=" + String.valueOf(this.getMaxInboundMessageSize()) + ", maxOutboundMessageSize=" + String.valueOf(this.getMaxOutboundMessageSize()) + ", maxInboundMetadataSize=" + String.valueOf(this.getMaxInboundMetadataSize()) + ", shutdownTimeout=" + this.getShutdownTimeout() + ", metadata=" + String.valueOf(this.getMetadata()) + ", inProcess=" + String.valueOf(this.getInProcess()) + ", tls=" + String.valueOf(this.getTls()) + ", sslBundle=" + this.getSslBundle() + ", retry=" + String.valueOf(this.getRetry()) + ", deadline=" + this.getDeadline() + ", compression=" + this.getCompression() + ", classes=" + String.valueOf(this.getClasses()) + ", stubs=" + String.valueOf(this.getStubs()) + ", services=" + String.valueOf(this.getServices()) + ")";
        }

        @Generated
        public Channel() {
        }

        @Generated
        public Channel(String name, String authority, DataSize maxInboundMessageSize, DataSize maxOutboundMessageSize, DataSize maxInboundMetadataSize, Long shutdownTimeout, List<Metadata> metadata, InProcess inProcess, Tls tls, String sslBundle, Retry retry, Long deadline, String compression, List<Class<? extends AbstractStub>> classes, List<String> stubs, List<String> services) {
            this.name = name;
            this.authority = authority;
            this.maxInboundMessageSize = maxInboundMessageSize;
            this.maxOutboundMessageSize = maxOutboundMessageSize;
            this.maxInboundMetadataSize = maxInboundMetadataSize;
            this.shutdownTimeout = shutdownTimeout;
            this.metadata = metadata;
            this.inProcess = inProcess;
            this.tls = tls;
            this.sslBundle = sslBundle;
            this.retry = retry;
            this.deadline = deadline;
            this.compression = compression;
            this.classes = classes;
            this.stubs = stubs;
            this.services = services;
        }
    }

    public static class InProcess {
        public static final String PREFIX = "grpc.client.in-process";
        private String name;

        @Generated
        public InProcess() {
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InProcess)) {
                return false;
            }
            InProcess other = (InProcess)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            return !(this$name == null ? other$name != null : !this$name.equals(other$name));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof InProcess;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcClientProperties.InProcess(name=" + this.getName() + ")";
        }
    }

    public static class Tls {
        public static final String PREFIX = "grpc.client.tls";
        private KeyManager keyManager;
        private TrustManager trustManager;

        @Generated
        public Tls() {
        }

        @Generated
        public KeyManager getKeyManager() {
            return this.keyManager;
        }

        @Generated
        public TrustManager getTrustManager() {
            return this.trustManager;
        }

        @Generated
        public void setKeyManager(KeyManager keyManager) {
            this.keyManager = keyManager;
        }

        @Generated
        public void setTrustManager(TrustManager trustManager) {
            this.trustManager = trustManager;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Tls)) {
                return false;
            }
            Tls other = (Tls)o;
            if (!other.canEqual(this)) {
                return false;
            }
            KeyManager this$keyManager = this.getKeyManager();
            KeyManager other$keyManager = other.getKeyManager();
            if (this$keyManager == null ? other$keyManager != null : !((Object)this$keyManager).equals(other$keyManager)) {
                return false;
            }
            TrustManager this$trustManager = this.getTrustManager();
            TrustManager other$trustManager = other.getTrustManager();
            return !(this$trustManager == null ? other$trustManager != null : !((Object)this$trustManager).equals(other$trustManager));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Tls;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            KeyManager $keyManager = this.getKeyManager();
            result = result * 59 + ($keyManager == null ? 43 : ((Object)$keyManager).hashCode());
            TrustManager $trustManager = this.getTrustManager();
            result = result * 59 + ($trustManager == null ? 43 : ((Object)$trustManager).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcClientProperties.Tls(keyManager=" + String.valueOf(this.getKeyManager()) + ", trustManager=" + String.valueOf(this.getTrustManager()) + ")";
        }

        public static class KeyManager {
            private Resource certChain;
            private Resource privateKey;
            private String privateKeyPassword;

            @Generated
            public KeyManager() {
            }

            @Generated
            public Resource getCertChain() {
                return this.certChain;
            }

            @Generated
            public Resource getPrivateKey() {
                return this.privateKey;
            }

            @Generated
            public String getPrivateKeyPassword() {
                return this.privateKeyPassword;
            }

            @Generated
            public void setCertChain(Resource certChain) {
                this.certChain = certChain;
            }

            @Generated
            public void setPrivateKey(Resource privateKey) {
                this.privateKey = privateKey;
            }

            @Generated
            public void setPrivateKeyPassword(String privateKeyPassword) {
                this.privateKeyPassword = privateKeyPassword;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof KeyManager)) {
                    return false;
                }
                KeyManager other = (KeyManager)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Resource this$certChain = this.getCertChain();
                Resource other$certChain = other.getCertChain();
                if (this$certChain == null ? other$certChain != null : !this$certChain.equals(other$certChain)) {
                    return false;
                }
                Resource this$privateKey = this.getPrivateKey();
                Resource other$privateKey = other.getPrivateKey();
                if (this$privateKey == null ? other$privateKey != null : !this$privateKey.equals(other$privateKey)) {
                    return false;
                }
                String this$privateKeyPassword = this.getPrivateKeyPassword();
                String other$privateKeyPassword = other.getPrivateKeyPassword();
                return !(this$privateKeyPassword == null ? other$privateKeyPassword != null : !this$privateKeyPassword.equals(other$privateKeyPassword));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof KeyManager;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Resource $certChain = this.getCertChain();
                result = result * 59 + ($certChain == null ? 43 : $certChain.hashCode());
                Resource $privateKey = this.getPrivateKey();
                result = result * 59 + ($privateKey == null ? 43 : $privateKey.hashCode());
                String $privateKeyPassword = this.getPrivateKeyPassword();
                result = result * 59 + ($privateKeyPassword == null ? 43 : $privateKeyPassword.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "GrpcClientProperties.Tls.KeyManager(certChain=" + String.valueOf(this.getCertChain()) + ", privateKey=" + String.valueOf(this.getPrivateKey()) + ", privateKeyPassword=" + this.getPrivateKeyPassword() + ")";
            }
        }

        public static class TrustManager {
            private Resource rootCerts;

            @Generated
            public TrustManager() {
            }

            @Generated
            public Resource getRootCerts() {
                return this.rootCerts;
            }

            @Generated
            public void setRootCerts(Resource rootCerts) {
                this.rootCerts = rootCerts;
            }

            @Generated
            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof TrustManager)) {
                    return false;
                }
                TrustManager other = (TrustManager)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Resource this$rootCerts = this.getRootCerts();
                Resource other$rootCerts = other.getRootCerts();
                return !(this$rootCerts == null ? other$rootCerts != null : !this$rootCerts.equals(other$rootCerts));
            }

            @Generated
            protected boolean canEqual(Object other) {
                return other instanceof TrustManager;
            }

            @Generated
            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Resource $rootCerts = this.getRootCerts();
                result = result * 59 + ($rootCerts == null ? 43 : $rootCerts.hashCode());
                return result;
            }

            @Generated
            public String toString() {
                return "GrpcClientProperties.Tls.TrustManager(rootCerts=" + String.valueOf(this.getRootCerts()) + ")";
            }
        }
    }

    public static class Retry {
        public static final String PREFIX = "grpc.client.retry";
        private Boolean enabled;
        private Integer maxRetryAttempts;
        private DataSize retryBufferSize;
        private DataSize perRpcBufferLimit;

        @Generated
        public Retry() {
        }

        @Generated
        public Boolean getEnabled() {
            return this.enabled;
        }

        @Generated
        public Integer getMaxRetryAttempts() {
            return this.maxRetryAttempts;
        }

        @Generated
        public DataSize getRetryBufferSize() {
            return this.retryBufferSize;
        }

        @Generated
        public DataSize getPerRpcBufferLimit() {
            return this.perRpcBufferLimit;
        }

        @Generated
        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public void setMaxRetryAttempts(Integer maxRetryAttempts) {
            this.maxRetryAttempts = maxRetryAttempts;
        }

        @Generated
        public void setRetryBufferSize(DataSize retryBufferSize) {
            this.retryBufferSize = retryBufferSize;
        }

        @Generated
        public void setPerRpcBufferLimit(DataSize perRpcBufferLimit) {
            this.perRpcBufferLimit = perRpcBufferLimit;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Retry)) {
                return false;
            }
            Retry other = (Retry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Boolean this$enabled = this.getEnabled();
            Boolean other$enabled = other.getEnabled();
            if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
                return false;
            }
            Integer this$maxRetryAttempts = this.getMaxRetryAttempts();
            Integer other$maxRetryAttempts = other.getMaxRetryAttempts();
            if (this$maxRetryAttempts == null ? other$maxRetryAttempts != null : !((Object)this$maxRetryAttempts).equals(other$maxRetryAttempts)) {
                return false;
            }
            DataSize this$retryBufferSize = this.getRetryBufferSize();
            DataSize other$retryBufferSize = other.getRetryBufferSize();
            if (this$retryBufferSize == null ? other$retryBufferSize != null : !this$retryBufferSize.equals(other$retryBufferSize)) {
                return false;
            }
            DataSize this$perRpcBufferLimit = this.getPerRpcBufferLimit();
            DataSize other$perRpcBufferLimit = other.getPerRpcBufferLimit();
            return !(this$perRpcBufferLimit == null ? other$perRpcBufferLimit != null : !this$perRpcBufferLimit.equals(other$perRpcBufferLimit));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Retry;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Boolean $enabled = this.getEnabled();
            result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
            Integer $maxRetryAttempts = this.getMaxRetryAttempts();
            result = result * 59 + ($maxRetryAttempts == null ? 43 : ((Object)$maxRetryAttempts).hashCode());
            DataSize $retryBufferSize = this.getRetryBufferSize();
            result = result * 59 + ($retryBufferSize == null ? 43 : $retryBufferSize.hashCode());
            DataSize $perRpcBufferLimit = this.getPerRpcBufferLimit();
            result = result * 59 + ($perRpcBufferLimit == null ? 43 : $perRpcBufferLimit.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcClientProperties.Retry(enabled=" + this.getEnabled() + ", maxRetryAttempts=" + this.getMaxRetryAttempts() + ", retryBufferSize=" + String.valueOf(this.getRetryBufferSize()) + ", perRpcBufferLimit=" + String.valueOf(this.getPerRpcBufferLimit()) + ")";
        }
    }

    public static class Metadata {
        private String key;
        private List<String> values = new ArrayList<String>();

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public List<String> getValues() {
            return this.values;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setValues(List<String> values) {
            this.values = values;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Metadata)) {
                return false;
            }
            Metadata other = (Metadata)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            List<String> this$values = this.getValues();
            List<String> other$values = other.getValues();
            return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Metadata;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            List<String> $values = this.getValues();
            result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcClientProperties.Metadata(key=" + this.getKey() + ", values=" + String.valueOf(this.getValues()) + ")";
        }

        @Generated
        public Metadata() {
        }

        @Generated
        public Metadata(String key, List<String> values) {
            this.key = key;
            this.values = values;
        }
    }

    public static class Refresh {
        public static final String PREFIX = "grpc.client.refresh";
        private boolean enabled = false;

        @Generated
        public Refresh() {
        }

        @Generated
        public boolean isEnabled() {
            return this.enabled;
        }

        @Generated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Refresh)) {
                return false;
            }
            Refresh other = (Refresh)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.isEnabled() == other.isEnabled();
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Refresh;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            return result;
        }

        @Generated
        public String toString() {
            return "GrpcClientProperties.Refresh(enabled=" + this.isEnabled() + ")";
        }
    }
}

