/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcChannelCreator;
import grpcstarter.client.GrpcClientCreator;
import grpcstarter.client.GrpcClientOptions;
import grpcstarter.client.GrpcClientProperties;
import io.grpc.stub.AbstractStub;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.cloud.context.scope.refresh.RefreshScopeRefreshedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.ObjectUtils;

public class GrpcClientRefreshScopeRefreshedEventListener
implements ApplicationListener<RefreshScopeRefreshedEvent>,
BeanFactoryAware {
    private DefaultListableBeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public void onApplicationEvent(RefreshScopeRefreshedEvent event) {
        this.refreshGrpcStubOptions();
    }

    private void refreshGrpcStubOptions() {
        String[] beanNames = this.beanFactory.getBeanNamesForType(AbstractStub.class, false, false);
        List grpcStubNames = Arrays.stream(beanNames).filter(arg_0 -> ((DefaultListableBeanFactory)this.beanFactory).containsSingleton(arg_0)).collect(Collectors.toList());
        if (ObjectUtils.isEmpty(grpcStubNames)) {
            return;
        }
        GrpcClientProperties properties = (GrpcClientProperties)this.beanFactory.getBean(GrpcClientProperties.class);
        grpcStubNames.stream().map(arg_0 -> ((DefaultListableBeanFactory)this.beanFactory).getBean(arg_0)).map(AbstractStub.class::cast).forEach(stub -> {
            GrpcClientOptions opt = (GrpcClientOptions)stub.getCallOptions().getOption(GrpcClientOptions.KEY);
            if (opt != null) {
                GrpcClientProperties.Channel config = GrpcChannelCreator.getMatchedConfig(AopProxyUtils.ultimateTargetClass((Object)stub), properties);
                GrpcClientCreator.setOptionValues(opt, config);
            }
        });
    }
}

