/*
 * Decompiled with CFR 0.152.
 */
package grpcstarter.client;

import grpcstarter.client.GrpcChannelCreator;
import grpcstarter.client.GrpcClientBeanDefinitionHandler;
import grpcstarter.client.GrpcClientCreator;
import grpcstarter.client.GrpcClientProperties;
import grpcstarter.client.GrpcStubBeanDefinitionRegistry;
import grpcstarter.client.Util;
import io.grpc.ManagedChannel;
import io.grpc.stub.AbstractStub;
import jakarta.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionOverrideException;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.NativeDetector;
import org.springframework.core.env.Environment;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class GrpcClientUtil {
    private static final Logger log = LoggerFactory.getLogger(GrpcClientUtil.class);
    static final String CHANNEL_BEAN_NAME_PREFIX = "grpc-channel-";
    static final String IS_CREATED_BY_FRAMEWORK = "isCreatedByFramework";
    private static final boolean SPRING_CLOUD_CONTEXT_PRESENT = ClassUtils.isPresent((String)"org.springframework.cloud.context.scope.refresh.RefreshScope", null);
    private static final boolean SUPPORT_REFRESH = !GrpcClientUtil.isAotProcessing() && !NativeDetector.inNativeImage();

    private GrpcClientUtil() {
        throw new UnsupportedOperationException("Cannot instantiate utility class");
    }

    public static void registerGrpcClientBean(@Nonnull DefaultListableBeanFactory beanFactory, @Nonnull Class<?> clz) {
        if (!AbstractStub.class.isAssignableFrom(clz)) {
            throw new IllegalArgumentException(String.valueOf(clz) + " is not a gRPC client");
        }
        String className = clz.getName();
        AbstractBeanDefinition abd = BeanDefinitionBuilder.genericBeanDefinition(clz, () -> new GrpcClientCreator((BeanFactory)beanFactory, clz).create()).getBeanDefinition();
        abd.setLazyInit(true);
        abd.setAttribute(IS_CREATED_BY_FRAMEWORK, (Object)true);
        abd.setResourceDescription("Auto registered by grpc-client-boot-starter");
        AbstractBeanDefinition definitionToUse = abd;
        if (GrpcStubBeanDefinitionRegistry.scanInfo.beanDefinitionHandler != null) {
            GrpcClientBeanDefinitionHandler beanDefinitionHandler = (GrpcClientBeanDefinitionHandler)BeanUtils.instantiateClass(GrpcStubBeanDefinitionRegistry.scanInfo.beanDefinitionHandler);
            definitionToUse = beanDefinitionHandler.handle((BeanDefinition)abd, clz);
        }
        if (definitionToUse == null) {
            return;
        }
        try {
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)new BeanDefinitionHolder((BeanDefinition)definitionToUse, className), (BeanDefinitionRegistry)beanFactory);
        }
        catch (BeanDefinitionOverrideException ignore) {
            log.warn("gRPC stub '{}' is included in base packages, you can remove it from 'clients' property.", (Object)className);
        }
    }

    public static void registerGrpcChannelBean(DefaultListableBeanFactory beanFactory, Environment environment, GrpcClientProperties.Channel channelConfig) {
        GrpcClientUtil.checkValid(channelConfig);
        String channelBeanName = CHANNEL_BEAN_NAME_PREFIX + channelConfig.getName();
        if (beanFactory.containsBean(channelBeanName)) {
            return;
        }
        AbstractBeanDefinition abd = BeanDefinitionBuilder.genericBeanDefinition(ManagedChannel.class, () -> GrpcClientUtil.createChannel((BeanFactory)beanFactory, channelConfig)).getBeanDefinition();
        abd.setAttribute(IS_CREATED_BY_FRAMEWORK, (Object)true);
        abd.setResourceDescription("Auto registered by grpc-client-boot-starter");
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)abd, channelBeanName);
        if (SUPPORT_REFRESH && SPRING_CLOUD_CONTEXT_PRESENT && GrpcClientUtil.getRefresh(environment).isEnabled()) {
            abd.setScope("refresh");
            holder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)beanFactory, (boolean)true);
        }
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)beanFactory);
    }

    private static boolean isValid(GrpcClientProperties.Channel channelConfig) {
        return StringUtils.hasText((String)channelConfig.getAuthority()) || channelConfig.getInProcess() != null && StringUtils.hasText((String)channelConfig.getInProcess().getName());
    }

    public static void registerGrpcChannelBeans(DefaultListableBeanFactory beanFactory, Environment environment) {
        GrpcClientProperties properties = Util.getProperties(environment);
        GrpcClientUtil.registerGrpcChannelBeans(beanFactory, environment, properties);
    }

    static void registerGrpcChannelBeans(DefaultListableBeanFactory beanFactory, Environment environment, GrpcClientProperties properties) {
        for (GrpcClientProperties.Channel channelConfig : properties.getChannels()) {
            GrpcClientUtil.registerGrpcChannelBean(beanFactory, environment, channelConfig);
        }
        GrpcClientProperties.Channel defaultChannel = properties.defaultChannel();
        if (GrpcClientUtil.isValid(defaultChannel)) {
            GrpcClientUtil.registerGrpcChannelBean(beanFactory, environment, defaultChannel);
        }
    }

    static GrpcClientProperties.Refresh getRefresh(Environment environment) {
        return (GrpcClientProperties.Refresh)Binder.get((Environment)environment).bind("grpc.client.refresh", GrpcClientProperties.Refresh.class).orElseGet(GrpcClientProperties.Refresh::new);
    }

    static ManagedChannel createChannel(BeanFactory beanFactory, GrpcClientProperties.Channel channelConfig) {
        GrpcClientUtil.checkValid(channelConfig);
        return new GrpcChannelCreator(beanFactory, channelConfig).create();
    }

    private static void checkValid(GrpcClientProperties.Channel channelConfig) {
        if (!GrpcClientUtil.isValid(channelConfig)) {
            throw new IllegalStateException("Channel authority or in-process name must be configured, name: " + channelConfig.getName());
        }
    }

    private static boolean isAotProcessing() {
        return Boolean.getBoolean("spring.aot.processing");
    }
}

